/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.sample;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dyndns.nuda.sample.Carrier;

public class Structure
implements Carrier {
    private static final long serialVersionUID = -3603005521575897405L;
    private List<Carrier> children = new LinkedList<Carrier>();
    private Carrier next;
    private Carrier previous;
    private Carrier parent;
    private int index = 0;

    @Override
    public Carrier getParent() {
        return this.parent;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public List<Carrier> getChildren() {
        if (this.children == null) {
            return new LinkedList<Carrier>();
        }
        return this.children;
    }

    @Override
    public boolean hasChild() {
        if (this.children == null) {
            return false;
        }
        return this.children.size() != 0;
    }

    @Override
    public int getLength() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public Carrier getNext() {
        return this.next;
    }

    @Override
    public Carrier getPrevious() {
        return this.previous;
    }

    @Override
    public Iterator<Carrier> iterator() {
        return this.children.iterator();
    }

    @Override
    public int compareTo(Carrier o) {
        if (o == null) {
            return 1;
        }
        return this.getIndex() - o.getIndex();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Carrier getChildByIndex(int index) {
        if (this.children == null) {
            return null;
        }
        if (this.children.size() < index) {
            return null;
        }
        return this.children.get(index);
    }
}

