/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.profile;

import org.dyndns.nuda.plugin.PluginDescription;
import org.dyndns.nuda.profile.Profiler;
import org.dyndns.nuda.profile.ProfilerRepository;
import org.dyndns.nuda.tools.util.StringUtil;

@PluginDescription(name="SimpleProfiler")
public class SimpleProfiler
implements Profiler {
    @Override
    public void init() {
        ProfilerRepository.setProfiler(this);
    }

    @Override
    public void reserveProfiler() {
        final long freeMem = Runtime.getRuntime().freeMemory();
        final long time = System.currentTimeMillis();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                long freeMemResult = Runtime.getRuntime().freeMemory();
                long endTime = System.currentTimeMillis() - time;
                String message = StringUtil.format("before[{} bytes] after[{} bytes] diff[{} bytes] time[{} s]", freeMem, freeMemResult, freeMem - freeMemResult, (double)endTime / 1000.0);
                System.out.println(message);
            }
        });
    }
}

