/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.dyndns.nuda.management.RUN_STATE;
import org.dyndns.nuda.plugin.Plugable;
import org.dyndns.nuda.plugin.PluginDescription;
import org.dyndns.nuda.tools.util.StringUtil;
import sun.misc.Service;

public class SysPluginLoader {
    private static final String CLASS_PATH_PREFIX = "META-INF/services";
    private static RUN_STATE state = RUN_STATE.SLEEP;

    public static void initializePluginLoader() {
        if (state.equals((Object)RUN_STATE.SLEEP)) {
            state = RUN_STATE.RUNNING;
        }
    }

    public void loadPlugin(Class<? extends Plugable> pluginClass) {
        block26: {
            if (pluginClass == null) {
                IllegalArgumentException e = new IllegalArgumentException("\u5f15\u6570\u304cnull\u3067\u3059");
                return;
            }
            if (!pluginClass.isInterface()) {
                String message = StringUtil.format("\u30af\u30e9\u30b9{}\u306f\u6709\u52b9\u306a\u30d7\u30e9\u30b0\u30a4\u30f3\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u30af\u30e9\u30b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093", pluginClass.getCanonicalName());
                IllegalArgumentException e = new IllegalArgumentException(message);
                return;
            }
            if (SysPluginLoader.isExistsSunMiscServiceProviderArchitecture()) {
                Iterator i = Service.providers(pluginClass);
                int count = 0;
                while (i.hasNext()) {
                    Object instance;
                    block25: {
                        instance = null;
                        try {
                            instance = i.next();
                            if (!instance.getClass().isAnnotationPresent(PluginDescription.class)) break block25;
                            PluginDescription pluginDescription = instance.getClass().getAnnotation(PluginDescription.class);
                        }
                        catch (Throwable t) {
                            if (!(t.getCause() instanceof InstantiationException)) continue;
                            InstantiationException instantiationException = (InstantiationException)t.getCause();
                            continue;
                        }
                    }
                    try {
                        Plugable plugable = (Plugable)Plugable.class.cast(instance);
                        plugable.init();
                        ++count;
                    }
                    catch (Throwable e) {
                        boolean cfr_ignored_0 = e instanceof ClassCastException;
                    }
                }
                return;
            }
            if (pluginClass.isAnnotationPresent(PluginDescription.class)) {
                PluginDescription i = pluginClass.getAnnotation(PluginDescription.class);
            }
            String clsName = pluginClass.getCanonicalName();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            StringBuilder b = new StringBuilder();
            b.append(CLASS_PATH_PREFIX);
            b.append("/");
            b.append(clsName);
            String path = b.toString();
            try {
                Enumeration<URL> urls = cl.getResources(path);
                ArrayList<String> classList = new ArrayList<String>();
                while (urls.hasMoreElements()) {
                    try {
                        URL url = urls.nextElement();
                        is = url.openStream();
                        isr = new InputStreamReader(is);
                        br = new BufferedReader(isr);
                        while (br.ready()) {
                            String line = br.readLine();
                            classList.add(line);
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                    }
                }
                if (classList.size() <= 0) break block26;
                for (String aClsName : classList) {
                    Class<?> plugin = null;
                    try {
                        plugin = cl.loadClass(aClsName);
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                    boolean isAssignable = pluginClass.isAssignableFrom(plugin);
                    if (!isAssignable) continue;
                    Object instance = null;
                    try {
                        instance = plugin.newInstance();
                    }
                    catch (InstantiationException e) {
                        continue;
                    }
                    catch (IllegalAccessException e2) {
                        continue;
                    }
                    Plugable p = instance;
                    p.init();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean isExistsSunMiscServiceProviderArchitecture() {
        try {
            Class.forName("sun.misc.Service");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

