/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.dyndns.nuda.di.DIManager;
import org.dyndns.nuda.logger.CommonLogger;
import org.dyndns.nuda.logger.LoggerAdaptor;
import org.dyndns.nuda.plugin.Plugable;
import org.dyndns.nuda.plugin.PluginDescription;
import org.dyndns.nuda.plugin.SysPluginLoader;
import org.dyndns.nuda.tools.util.StringUtil;
import sun.misc.Service;

public class PluginLoader {
    private static final String CLASS_PATH_PREFIX = "META-INF/services";
    private static LoggerAdaptor logger = CommonLogger.getLoggerAdaptor().getLogger(PluginLoader.class);

    public PluginLoader() {
        SysPluginLoader.initializePluginLoader();
    }

    public void loadPlugin(Class<? extends Plugable> pluginClass) {
        block32: {
            if (pluginClass == null) {
                IllegalArgumentException e = new IllegalArgumentException("\u5f15\u6570\u304cnull\u3067\u3059");
                logger.error("\u30a8\u30e9\u30fc:", e);
                return;
            }
            if (!pluginClass.isInterface()) {
                String message = StringUtil.format("\u30af\u30e9\u30b9{}\u306f\u6709\u52b9\u306a\u30d7\u30e9\u30b0\u30a4\u30f3\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u30af\u30e9\u30b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093", pluginClass.getCanonicalName());
                IllegalArgumentException e = new IllegalArgumentException(message);
                logger.error("\u30a8\u30e9\u30fc:", e);
                return;
            }
            if (PluginLoader.isExistsSunMiscServiceProviderArchitecture()) {
                Iterator i = Service.providers(pluginClass);
                int count = 0;
                while (i.hasNext()) {
                    Object instance = null;
                    try {
                        instance = i.next();
                        PluginDescription desc = instance.getClass().getAnnotation(PluginDescription.class);
                        if (desc != null) {
                            logger.debug("sun.misc\u30d1\u30c3\u30b1\u30fc\u30b8\u306e\u30b5\u30fc\u30d3\u30b9\u30d7\u30ed\u30d0\u30a4\u30c0\u6a5f\u80fd\u3092\u4f7f\u7528\u3057\u3066\u3001\u30d7\u30e9\u30b0\u30a4\u30f3[{}]\u306e\u30ed\u30fc\u30c9\u3092\u884c\u3044\u307e\u3059", desc.name());
                        } else {
                            logger.debug("sun.misc\u30d1\u30c3\u30b1\u30fc\u30b8\u306e\u30b5\u30fc\u30d3\u30b9\u30d7\u30ed\u30d0\u30a4\u30c0\u6a5f\u80fd\u3092\u4f7f\u7528\u3057\u3066\u3001\u30d7\u30e9\u30b0\u30a4\u30f3[{}]\u306e\u30ed\u30fc\u30c9\u3092\u884c\u3044\u307e\u3059", instance.getClass().getCanonicalName());
                        }
                    }
                    catch (Throwable t) {
                        if (t.getCause() instanceof InstantiationException) {
                            InstantiationException ie = (InstantiationException)t.getCause();
                            logger.error("[{}]\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u30a8\u30f3\u30c8\u30ea\uff1a\u30af\u30e9\u30b9[{}]\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "META-INF/services/" + pluginClass.getCanonicalName(), ie.getMessage());
                            continue;
                        }
                        logger.error("\u30a8\u30e9\u30fc:", t);
                        continue;
                    }
                    try {
                        Plugable plugable = (Plugable)Plugable.class.cast(instance);
                        DIManager.inject(plugable);
                        plugable.init();
                        logger.debug("[{}]\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u30a8\u30f3\u30c8\u30ea\uff1a\u30d7\u30e9\u30b0\u30a4\u30f3\u30af\u30e9\u30b9[{}]\u306e\u30ed\u30fc\u30c9\u306b\u6210\u529f\u3057\u307e\u3057\u305f", "META-INF/services/" + pluginClass.getCanonicalName(), plugable.getClass().getCanonicalName());
                        ++count;
                    }
                    catch (Throwable e) {
                        if (e instanceof ClassCastException) {
                            logger.error("[{}]\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u30a8\u30f3\u30c8\u30ea\uff1a\u30af\u30e9\u30b9[{}]\u306f\u6709\u52b9\u306a\u30d7\u30e9\u30b0\u30a4\u30f3\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u3092\u5b9f\u88c5\u3057\u3066\u304a\u308a\u307e\u305b\u3093", "META-INF/services/" + pluginClass.getCanonicalName(), instance.getClass().getCanonicalName());
                            continue;
                        }
                        logger.error("\u30a8\u30e9\u30fc:", e);
                    }
                }
                if (count == 0) {
                    logger.debug("\u30ed\u30fc\u30c9\u5bfe\u8c61\u30d7\u30e9\u30b0\u30a4\u30f3\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3067\u3057\u305f[{}]", pluginClass.getCanonicalName());
                }
                return;
            }
            logger.debug("{}", "CommonTools\u30e9\u30a4\u30d6\u30e9\u30ea\u72ec\u81ea\u306e\u30b5\u30fc\u30d3\u30b9\u30d7\u30ed\u30d0\u30a4\u30c0\u6a5f\u80fd\u3092\u4f7f\u7528\u3057\u3066\u3001\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30ed\u30fc\u30c9\u3092\u884c\u3044\u307e\u3059");
            if (pluginClass.isAnnotationPresent(PluginDescription.class)) {
                PluginDescription desc = pluginClass.getAnnotation(PluginDescription.class);
                logger.debug("CommonTools\u30e9\u30a4\u30d6\u30e9\u30ea\u72ec\u81ea\u306e\u30b5\u30fc\u30d3\u30b9\u30d7\u30ed\u30d0\u30a4\u30c0\u6a5f\u80fd\u3092\u4f7f\u7528\u3057\u3066\u3001\u30d7\u30e9\u30b0\u30a4\u30f3[{}]\u306e\u30ed\u30fc\u30c9\u3092\u884c\u3044\u307e\u3059", desc.name());
            } else {
                logger.debug("{}", "CommonTools\u30e9\u30a4\u30d6\u30e9\u30ea\u72ec\u81ea\u306e\u30b5\u30fc\u30d3\u30b9\u30d7\u30ed\u30d0\u30a4\u30c0\u6a5f\u80fd\u3092\u4f7f\u7528\u3057\u3066\u3001\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30ed\u30fc\u30c9\u3092\u884c\u3044\u307e\u3059");
            }
            String clsName = pluginClass.getCanonicalName();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            StringBuilder b = new StringBuilder();
            b.append(CLASS_PATH_PREFIX);
            b.append("/");
            b.append(clsName);
            String path = b.toString();
            try {
                Enumeration<URL> urls = cl.getResources(path);
                ArrayList<String> classList = new ArrayList<String>();
                while (urls.hasMoreElements()) {
                    try {
                        URL url = urls.nextElement();
                        is = url.openStream();
                        isr = new InputStreamReader(is);
                        br = new BufferedReader(isr);
                        while (br.ready()) {
                            String line = br.readLine();
                            classList.add(line);
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                    }
                }
                if (classList.size() <= 0) break block32;
                for (String aClsName : classList) {
                    Class<?> plugin = null;
                    try {
                        plugin = cl.loadClass(aClsName);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("[{}]\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u30a8\u30f3\u30c8\u30ea\uff1a\u30af\u30e9\u30b9\u30d1\u30b9\u4e0a\u306b\u30af\u30e9\u30b9[{}]\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3093\u3067\u3057\u305f", "META-INF/services/" + aClsName, e.getMessage());
                        continue;
                    }
                    boolean isAssignable = pluginClass.isAssignableFrom(plugin);
                    if (isAssignable) {
                        Object instance = null;
                        try {
                            instance = plugin.newInstance();
                        }
                        catch (InstantiationException e) {
                            logger.error("[{}]\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u30a8\u30f3\u30c8\u30ea\uff1a\u30af\u30e9\u30b9[{}]\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f:\u5f15\u6570\u306a\u3057\u306e\u30d1\u30d6\u30ea\u30c3\u30af\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u304c\u5b58\u5728\u3057\u307e\u305b\u3093", "META-INF/services/" + aClsName, e.getMessage());
                            continue;
                        }
                        catch (IllegalAccessException e2) {
                            logger.error("[{}]\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u30a8\u30f3\u30c8\u30ea\uff1a\u30af\u30e9\u30b9[{}]\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f:\u5f15\u6570\u306a\u3057\u306e\u30d1\u30d6\u30ea\u30c3\u30af\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u304c\u5b58\u5728\u3057\u307e\u305b\u3093", "META-INF/services/" + aClsName, e2.getMessage());
                            continue;
                        }
                        Plugable p = instance;
                        DIManager.inject(p);
                        p.init();
                    }
                    if (isAssignable) continue;
                    logger.error("[{}]\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u30a8\u30f3\u30c8\u30ea\uff1a\u30af\u30e9\u30b9[{}]\u306f\u6709\u52b9\u306a\u30d7\u30e9\u30b0\u30a4\u30f3\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u3092\u5b9f\u88c5\u3057\u3066\u304a\u308a\u307e\u305b\u3093", "META-INF/services/" + pluginClass.getCanonicalName(), aClsName);
                }
            }
            catch (IOException e2) {
                logger.error("\u30a8\u30e9\u30fc:", e2);
            }
        }
    }

    private static boolean isExistsSunMiscServiceProviderArchitecture() {
        try {
            Class.forName("sun.misc.Service");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

