/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.management;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dyndns.nuda.management.PRODUCT_STATUS;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int version = 1301;
    private static final String versionParsePatternStr = "1(\\d{2})2(\\d{2})3(\\d{2})(\\d{1})";
    private static final Pattern VERSION_PATTERN = Pattern.compile("1(\\d{2})2(\\d{2})3(\\d{2})(\\d{1})");
    private int currentVersion = 0;
    private int majorVersion = 0;
    private int minorVersion = 0;
    private int branchVersion = 0;
    private int productStatus = 0;

    public Version(int version) {
        String strVersion = Integer.valueOf(version).toString();
        Matcher matcher = VERSION_PATTERN.matcher(strVersion);
        if (!matcher.matches()) {
            this.currentVersion = 0;
            int toolVersion = 0;
            if (version < 0) {
                this.currentVersion = 0;
                toolVersion = 0;
            } else {
                this.currentVersion = version;
                toolVersion = version;
            }
            this.majorVersion = (toolVersion - toolVersion % 1000) / 1000;
            if (this.majorVersion < 0) {
                this.majorVersion = 0;
            }
            this.minorVersion = ((toolVersion -= this.majorVersion * 1000) - toolVersion % 100) / 100;
            this.branchVersion = ((toolVersion -= this.minorVersion * 100) - toolVersion % 10) / 10;
            this.productStatus = ((toolVersion -= this.branchVersion * 10) - toolVersion % 1) / 1;
        } else {
            this.majorVersion = Integer.valueOf(matcher.group(1));
            this.minorVersion = Integer.valueOf(matcher.group(2));
            this.branchVersion = Integer.valueOf(matcher.group(3));
            this.productStatus = Integer.valueOf(matcher.group(4));
        }
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getBranchVersion() {
        return this.branchVersion;
    }

    public PRODUCT_STATUS getProductStatus() {
        return PRODUCT_STATUS.create(this.productStatus);
    }

    public Version versionUp() {
        int currentMajorVersion = this.majorVersion;
        int currentMinorVersion = this.minorVersion;
        int currentBranchVersion = this.branchVersion;
        return null;
    }

    public Version revisionUp() {
        int currentMajorVersion = this.majorVersion;
        int currentMinorVersion = this.minorVersion;
        int currentBranchVersion = this.branchVersion;
        return null;
    }

    public Version suffixUp() {
        int currentMajorVersion = this.majorVersion;
        int currentMinorVersion = this.minorVersion;
        int currentBranchVersion = this.branchVersion;
        return null;
    }

    public void changeProductStatus(PRODUCT_STATUS status) {
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.majorVersion < 1) {
            b.append((Object)this.majorVersion).append(".");
        } else {
            b.append((Object)(this.majorVersion - 1)).append(".");
        }
        b.append((Object)this.minorVersion).append(".");
        b.append((Object)this.branchVersion);
        b.append(PRODUCT_STATUS.create(this.productStatus).getStatusName());
        return b.toString();
    }

    @Override
    public int compareTo(Version arg0) {
        if (arg0 == null) {
            return 1;
        }
        int major = this.majorVersion - arg0.majorVersion;
        int minor = this.minorVersion - arg0.minorVersion;
        int branch = this.branchVersion - arg0.branchVersion;
        return major * 100 + minor * 10 + branch;
    }
}

