/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.logger;

import java.util.LinkedList;
import java.util.List;
import org.dyndns.nuda.logger.LogAdaptorResolver;
import org.dyndns.nuda.logger.LoggerAdaptor;
import org.dyndns.nuda.logger.NOPLogAdaptorResolver;
import org.dyndns.nuda.management.RUN_STATE;
import org.dyndns.nuda.plugin.SysPluginLoader;

public class AutoLoggerAdaptorResolver
implements LogAdaptorResolver {
    private static List<LogAdaptorResolver> resolvers = new LinkedList<LogAdaptorResolver>();
    private static RUN_STATE state = RUN_STATE.SLEEP;

    public static AutoLoggerAdaptorResolver newInstance() {
        if (state.equals((Object)RUN_STATE.SLEEP)) {
            new SysPluginLoader().loadPlugin(LogAdaptorResolver.class);
            state = RUN_STATE.RUNNING;
        }
        return new AutoLoggerAdaptorResolver();
    }

    public static void addLogAdaptorResolver(LogAdaptorResolver resolver) {
        if (resolver != null) {
            System.out.println("AutoLoggerAdaptorResolver:\u6b21\u306e\u30ea\u30be\u30eb\u30d0\u3092\u8ffd\u52a0\u3057\u307e\u3059:" + resolver.getClass().getCanonicalName());
            resolvers.add(resolver);
        }
    }

    private AutoLoggerAdaptorResolver() {
    }

    @Override
    public boolean accept() {
        for (LogAdaptorResolver resolver : resolvers) {
            boolean result = resolver.accept();
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public LoggerAdaptor getAdaptor() {
        for (LogAdaptorResolver resolver : resolvers) {
            boolean result = resolver.accept();
            if (!result) continue;
            return resolver.getAdaptor();
        }
        return new NOPLogAdaptorResolver().getAdaptor();
    }

    @Override
    public void init() {
    }
}

