/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper;

import java.sql.Connection;
import java.sql.DriverManager;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.dyndns.nuda.mapper.JDBCXMLInvocationHandler;
import org.dyndns.nuda.mapper.TestInterface;
import org.dyndns.nuda.mapper.TestQueryBean;
import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JDBCXMLInvocationHandlerTest
extends TestCase {
    @Before
    public void setUp() throws Exception {
        Class.forName("org.dyndns.nuda.mapper.driver.SorMapDriver");
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testJDBCXMLInvocationHandler_invalid01_Connection_is_null() {
        try {
            new JDBCXMLInvocationHandler(null, String.class);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"JDBC-Connection is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandler_invalid02_HandlerClass_is_null() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, null);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"handler class is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandler_invalid03_HandlerClass_is_not_interface() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, String.class);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"unsupported class [class java.lang.String]. class is not a interface", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandler_invalid04_HandlerClass_is_not_presented_by_JDBCQuery() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, Connection.class);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"unsupported class [interface java.sql.Connection]. class is not supported annotation<org.dyndns.nuda.repserv.datastore.annotation.JDBCQuery>", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerBoolean_invalid01_Connection_is_null() {
        try {
            new JDBCXMLInvocationHandler(null, String.class, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"JDBC-Connection is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerBoolean_invalid02_HandlerClass_is_null() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, null, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"handler class is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerBoolean_invalid03_HandlerClass_is_not_interface() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, String.class, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"unsupported class [class java.lang.String]. class is not a interface", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerBoolean_invalid04_HandlerClass_is_not_presented_by_JDBCQuery() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, Connection.class, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"unsupported class [interface java.sql.Connection]. class is not supported annotation<org.dyndns.nuda.repserv.datastore.annotation.JDBCQuery>", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerBooleanBoolean_invalid01_Connection_is_null() {
        try {
            new JDBCXMLInvocationHandler(null, String.class, false, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"JDBC-Connection is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerBooleanBoolean_invalid02_HandlerClass_is_null() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, null, false, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"handler class is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerBooleanBoolean_invalid03_HandlerClass_is_not_interface() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, String.class, false, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"unsupported class [class java.lang.String]. class is not a interface", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerBooleanBoolean_invalid04_HandlerClass_is_not_presented_by_JDBCQuery() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, Connection.class, false, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"unsupported class [interface java.sql.Connection]. class is not supported annotation<org.dyndns.nuda.repserv.datastore.annotation.JDBCQuery>", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerClassLoaderBooleanBoolean_invalid01_Connection_is_null() {
        try {
            new JDBCXMLInvocationHandler(null, String.class, Thread.currentThread().getContextClassLoader(), false, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"JDBC-Connection is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerClassLoaderBooleanBoolean_invalid02_HandlerClass_is_null() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, null, Thread.currentThread().getContextClassLoader(), false, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"handler class is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerClassLoaderBooleanBoolean_invalid03_HandlerClass_is_not_interface() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, String.class, Thread.currentThread().getContextClassLoader(), false, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"unsupported class[class java.lang.String]. class is not a interface", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerClassLoaderBooleanBoolean_invalid04_HandlerClass_is_not_presented_by_JDBCQuery() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, Connection.class, Thread.currentThread().getContextClassLoader(), false, false);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"unsupported class [interface java.sql.Connection]. class is not supported annotation<org.dyndns.nuda.repserv.datastore.annotation.JDBCQuery>", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerClassLoader_invalid01_Connection_is_null() {
        try {
            new JDBCXMLInvocationHandler(null, String.class, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assert.assertEquals((String)"JDBC-Connection is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerClassLoader_invalid02_HandlerClass_is_null() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, null, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assert.assertEquals((String)"handler class is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerClassLoader_invalid03_HandlerClass_is_not_interface() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, String.class, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assert.assertEquals((String)"unsupported class [class java.lang.String]. class is not a interface", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerClassLoader_invalid04_HandlerClass_is_not_presented_by_JDBCQuery() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            new JDBCXMLInvocationHandler(con, Connection.class, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assert.assertEquals((String)"unsupported class [interface java.sql.Connection]. class is not supported annotation<org.dyndns.nuda.repserv.datastore.annotation.JDBCQuery>", (String)e.getMessage());
        }
    }

    @Test
    public void testSetConnection() {
        try {
            JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler(null, TestInterface.class);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"JDBC-Connection is NULL", (String)e.getMessage());
        }
    }

    @Test
    public void testIsUseAutoCommit() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler(con, TestQueryBean.class, Thread.currentThread().getContextClassLoader());
            h.setUseAutoCommit(true);
            Assert.assertTrue((boolean)h.isUseAutoCommit());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertEquals((String)"", (String)e.getMessage());
        }
    }

    @Test
    public void testIsManualTransaction() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler(con, TestQueryBean.class, Thread.currentThread().getContextClassLoader());
            h.setManualTransaction(true);
            Assert.assertTrue((boolean)h.isManualTransaction());
        }
        catch (Exception e) {
            Assert.assertEquals((String)"", (String)e.getMessage());
        }
    }

    @Test
    public void testGetConnection01() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler(con, TestQueryBean.class, Thread.currentThread().getContextClassLoader());
            Assert.assertEquals((Object)con, (Object)h.getConnection());
        }
        catch (Exception e) {
            Assert.assertEquals((String)"", (String)e.getMessage());
        }
    }

    public void testGetConnection02() {
        try {
            Connection con = DriverManager.getConnection("jdbc:mysql://localhost:3306/games", "root", "bpg26rtdyy");
            JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler(con, TestQueryBean.class, Thread.currentThread().getContextClassLoader());
            Connection con0 = h.getConnection();
            if (con0 instanceof SQLInterfaceConnection) {
                SQLInterfaceConnection con1 = (SQLInterfaceConnection)con0;
                Assert.assertEquals((Object)con, (Object)con1.getSourceConnection());
            } else {
                Assert.fail((String)"SQL\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
            }
        }
        catch (Exception e) {
            Assert.assertEquals((String)"", (String)e.getMessage());
        }
    }

    public void testGetConnection03() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler(con, TestQueryBean.class, Thread.currentThread().getContextClassLoader());
            h.setConnection((SQLInterfaceConnection)con);
            Connection con0 = h.getConnection();
            if (con0 instanceof SQLInterfaceConnection) {
                Assert.assertEquals((Object)con, (Object)con0);
            } else {
                Assert.fail((String)"SQL\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
            }
        }
        catch (Exception e) {
            Assert.assertEquals((String)"", (String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerConnectionClassOfQ() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler(con, TestQueryBean.class);
            Assert.assertTrue((boolean)true);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerConnectionClassOfQBoolean() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler(con, TestQueryBean.class, true);
            Assert.assertTrue((boolean)h.isUseAutoCommit());
            Assert.assertTrue((!h.isManualTransaction() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerConnectionClassOfQBooleanBoolean() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler(con, TestQueryBean.class, false, true);
            Assert.assertTrue((!h.isUseAutoCommit() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)h.isManualTransaction());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerConnectionClassOfQClassLoaderBooleanBoolean() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler(con, TestQueryBean.class, ((Object)((Object)this)).getClass().getClassLoader(), false, true);
            Assert.assertTrue((!h.isUseAutoCommit() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)h.isManualTransaction());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testJDBCXMLInvocationHandlerConnectionClassOfQClassLoader() {
        try {
            Connection con = DriverManager.getConnection("jdbc:sormap://localhost:3306/games?subProtocol=mysql", "root", "bpg26rtdyy");
            JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler(con, TestQueryBean.class, ((Object)((Object)this)).getClass().getClassLoader());
            Assert.assertTrue((boolean)h.isUseAutoCommit());
            Assert.assertTrue((!h.isManualTransaction() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInitContainerConnectionClassOfQBooleanBoolean01() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQBooleanBoolean02() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQBooleanBoolean03() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQBooleanBoolean04() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQBooleanBoolean05() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQBooleanBoolean06() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQClassLoaderBooleanBoolean01() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQClassLoaderBooleanBoolean02() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQClassLoaderBooleanBoolean03() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQClassLoaderBooleanBoolean04() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQClassLoaderBooleanBoolean05() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQClassLoaderBooleanBoolean06() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQClassLoaderBooleanBoolean07() {
        Assert.fail();
    }

    @Test
    public void testInitContainerConnectionClassOfQClassLoaderBooleanBoolean08() {
        Assert.fail();
    }

    @Test
    public void testInitSQLIFCtrlCommand01() {
        Assert.fail();
    }

    @Test
    public void testInitSQLIFCtrlCommand02() {
        Assert.fail();
    }

    @Test
    public void testInitSQLIFCtrlCommand03() {
        Assert.fail();
    }

    @Test
    public void testConvertFromXML01() {
        Assert.fail();
    }

    @Test
    public void testConvertFromXML02() {
        Assert.fail();
    }

    @Test
    public void testConvertFromXML03() {
        Assert.fail();
    }

    @Test
    public void testConvertFromXML04() {
        Assert.fail();
    }

    @Test
    public void testConvertFromXML05() {
        Assert.fail();
    }

    @Test
    public void testInitStatement01() {
        Assert.fail();
    }

    @Test
    public void testInitStatement02() {
        Assert.fail();
    }

    @Test
    public void testInitStatement03() {
        Assert.fail();
    }

    @Test
    public void testInitStatement04() {
        Assert.fail();
    }

    @Test
    public void testInitStatement05() {
        Assert.fail();
    }

    @Test
    public void testInitStatement06() {
        Assert.fail();
    }

    @Test
    public void testInitStatement07() {
        Assert.fail();
    }

    @Test
    public void testInitStatement08() {
        Assert.fail();
    }

    @Test
    public void testInitStatement09() {
        Assert.fail();
    }

    @Test
    public void testInitStatement10() {
        Assert.fail();
    }

    @Test
    public void testInitStatement11() {
        Assert.fail();
    }

    @Test
    public void testInitStatement12() {
        Assert.fail();
    }

    @Test
    public void testInitStatement13() {
        Assert.fail();
    }

    @Test
    public void testInitStatement14() {
        Assert.fail();
    }

    @Test
    public void testInvoke01() {
        JDBCXMLInvocationHandlerTest.fail((String)"\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }
}

