/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.sql.editor;

import java.util.ArrayList;
import java.util.List;

import org.dyndns.nuda.plugin.PluginLoader;

public class AutoSQLEditorResolver implements SQLEditorResolver {
	private static List<SQLEditorResolver>	resolvers	=
															new ArrayList<SQLEditorResolver>();
	private static SQLEditorResolver		ME			= null;
	
	private AutoSQLEditorResolver() {
		// カスタム条件付きSQLエディタ
		this.resolvers.add(new ConditionedSQLEditorResolver());
		
		// なにもしないSQLエディタ
		this.resolvers.add(new NOPSQLEditorResolver());
	}
	
	public static void addResolver(final SQLEditorResolver resolver) {
		if (resolver != null) {
			resolvers.add(resolver);
		}
	}
	
	private List<SQLEditorResolver> getResolvers() {
		return resolvers;
	}
	
	public static SQLEditorResolver getInstance() {
		if (ME == null) {
			ME = new AutoSQLEditorResolver();
			PluginLoader loader = new PluginLoader();
			loader.loadPlugin(SQLEditorResolver.class);
		}
		return ME;
	}
	
	@Override
	public boolean accept(final Object[] args, final String sql) {
		for (SQLEditorResolver resolver : resolvers) {
			if (resolver.accept(args, sql)) {
				return true;
			}
		}
		return false;
	}
	
	@Override
	public String editSql(final Object[] args, final String sql) {
		String tmpSQL = sql;
		for (SQLEditorResolver resolver : this.getResolvers()) {
			if (resolver.accept(args, sql)) {
				tmpSQL = resolver.editSql(args, tmpSQL);
			}
		}
		return tmpSQL;
	}
	
	@Override
	public void init() {
		// TODO 自動生成されたメソッド・スタブ
		
	}
	
}
