/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.parser;

import org.dyndns.nuda.mapper.SQLContainer;
import org.dyndns.nuda.plugin.Plugable;

/**
 * SQLパーサを表すインタフェースです
 * 
 * @author nkoseki
 * 
 */
public interface SQLParser extends Plugable {
	
	/**
	 * 引数に指定されたクエリタイプとSQLステートメントに対して,このパーサが許容するかどうかテストします.<BR />
	 * パーサが許容するクエリタイプは以下の通りです.<BR />
	 * 
	 * <ul>
	 * <li>SELECT</li>
	 * <li>INSERT</li>
	 * <li>UPDATE</li>
	 * <li>DELETE</li>
	 * <li>CREATE</li>
	 * <li>OTHER</li>
	 * </ul>
	 * 
	 * 
	 * @param queryType
	 *            クエリタイプ
	 * @param sql
	 *            SQLステートメント
	 * @return 許容する:true/許容しない:false
	 */
	public boolean accept(String queryType, String sql);
	
	/**
	 * 引数に指定されたクエリタイプ、SQL入力シーケンスを元にSQLコンテナインタフェースの実装クラスを生成して返します
	 * 
	 * @param queryType
	 *            クエリタイプ
	 * @param sql
	 *            SQL入力シーケンス
	 * @return SQLコンテナインタフェース実装
	 */
	public SQLContainer parse(String qyeryId, String queryType, String sql);
}
