package org.dyndns.nuda.mapper.parameter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class AutoSQLParameter implements SQLParameter {
	private static AutoSQLParameter	ME				= null;
	private static final Object		LOCK			= new Object();
	private List<SQLParameter>		parameterList	=
														new ArrayList<SQLParameter>();
	
	private AutoSQLParameter() {
		this.parameterList.add(new IntSQLParameter());
		this.parameterList.add(new StringSQLParameter());
		this.parameterList.add(new JavaUtilDateSQLParameter());
		this.parameterList.add(new JavaSqlDateSQLParameter());
		this.parameterList.add(new LongSQLParameter());
		this.parameterList.add(new DoubleSQLParameter());
		this.parameterList.add(new BigIntegerSQLParameter());
		this.parameterList.add(new BigDecimalSQLParameter());
		this.parameterList.add(new BooleanSQLParameter());
		this.parameterList.add(new NOPSQLParameter());
	}
	
	public static AutoSQLParameter getInstance() {
		if (ME == null) {
			synchronized (LOCK) {
				if (ME == null) {
					ME = new AutoSQLParameter();
				}
			}
		}
		return ME;
	}
	
	@Override
	public boolean accept(final Class<?> parameterType) {
		return true;
	}
	
	@Override
	public void setParameter(final PreparedStatement pstmt, final int index,
			final Object parameter, final Class<?> parameterType)
			throws SQLException {
		if (pstmt == null) {
			return;
		}
		for (SQLParameter p : this.parameterList) {
			if (p.accept(parameterType)) {
				p.setParameter(pstmt, index, parameter, parameterType);
				break;
			}
		}
	}
	
}
