/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.cache;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.dyndns.nuda.mapper.SQLInterfaceBean;
import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;
import org.dyndns.nuda.plugin.PluginLoader;

public class CommonCacheManager implements CacheManager {
	
	private static CacheManager	cacheManager;
	private static CacheManager	defaultCacheManager	= new EmbedCacheManager();
	
	private static CacheManager	ME					= null;
	
	@Override
	public void init() {
		// TODO 自動生成されたメソッド・スタブ		
	}
	
	public static CacheManager getInstance() {
		if (ME == null) {
			ME = new CommonCacheManager();
			
			PluginLoader loader = new PluginLoader();
			loader.loadPlugin(CacheManager.class);
		}
		return ME;
	}
	
	private CommonCacheManager() {
		
	}
	
	public static void setCacheManager(final CacheManager cm) {
		cacheManager = cm;
	}
	
	@Override
	public PreparedStatement getStatement(final String sql,
			final SQLInterfaceConnection con,
			final SQLInterfaceBean sqlInterfaceBean) throws SQLException {
		if (cacheManager == null) {
			return defaultCacheManager.getStatement(sql, con, sqlInterfaceBean);
		} else {
			return cacheManager.getStatement(sql, con, sqlInterfaceBean);
		}
	}

	@Override
	public void deleteCache(String sql) {
		// TODO Auto-generated method stub
		if(cacheManager != null) {
			defaultCacheManager.deleteCache(sql);
		} else {
			cacheManager.deleteCache(sql);
		}
	}
	
}
