/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.sql.editor;

import org.dyndns.nuda.plugin.Plugable;

/**
 * 入力ソースに対するSQLエディタを解決するためのインタフェースです
 * 
 * @author nkoseki
 * 
 */
public interface SQLEditorResolver extends Plugable {
	
	/**
	 * 引数に指定された入力ソースに対して、実装クラスが適合する場合にtrueを返します
	 * 
	 * @param args
	 * @param sql
	 * @return
	 */
	public boolean accept(Object[] args, String sql);
	
	/**
	 * 引数に指定された入力ソースを元に、SQLを編集して返します
	 * 
	 * @param args
	 * @param sql
	 * @return
	 */
	public String editSql(Object[] args, String sql);
}
