/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.helper;

import java.lang.reflect.Method;
import java.util.Arrays;

/**
 * SQLInterfaceコンテナ制御コマンドのシグニチャを表すクラスです
 * 
 * @author nkoseki
 * 
 */
public class CommandSigniture {
	private String		methodName	= "";
	private Class<?>	returnType;
	private Class<?>[]	paramTypes;
	
	private Method		origin;
	
	/**
	 * 引数にMethodオブジェクトを指定してインスタンスを生成します
	 * 
	 * @param method
	 *            CommandSignitureオブジェクトの生成元となるMethodオブジェクト
	 */
	public CommandSigniture(final Method method) {
		if (method == null) {
			throw new IllegalArgumentException(
				"first-parameter[method] is cannot be null");
		}
		this.methodName = method.getName();
		this.returnType = method.getReturnType();
		this.paramTypes = method.getParameterTypes();
		
		this.origin = method;
	}
	
	/**
	 * このSQLInterfaceコンテナ制御コマンドのコマンド名を返します
	 * 
	 * @return コンテナ制御コマンド名
	 */
	public String getCommandName() {
		return this.methodName;
	}
	
	/**
	 * このSQLInterfaceコンテナ制御コマンドの戻り値の型をクラスオブジェクトで返します
	 * 
	 * @return コンテナ制御コマンド戻り値型
	 */
	public Class<?> getReturnType() {
		return this.returnType;
	}
	
	/**
	 * このSQLInterfaceコンテナ制御コマンドのパラメータの型をクラスオブジェクトの配列で返します
	 * 
	 * @return コンテナ制御コマンドパラメータ型
	 */
	public Class<?>[] getParamTypes() {
		return Arrays.copyOf(this.paramTypes, this.paramTypes.length);
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result =
			prime
				* result
				+ ((this.methodName == null) ? 0 : this.methodName.hashCode());
		result = prime * result + Arrays.hashCode(this.paramTypes);
		result =
			prime
				* result
				+ ((this.returnType == null) ? 0 : this.returnType.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (this.getClass() != obj.getClass()) {
			return false;
		}
		CommandSigniture other = (CommandSigniture) obj;
		if (this.methodName == null) {
			if (other.methodName != null) {
				return false;
			}
		} else if (!this.methodName.equals(other.methodName)) {
			return false;
		}
		if (!Arrays.equals(this.paramTypes, other.paramTypes)) {
			return false;
		}
		
		if (this.paramTypes.length != other.paramTypes.length) {
			return false;
		}
		
		for (int idx = 0; idx < this.paramTypes.length; idx++) {
			Class<?> a = this.paramTypes[idx];
			Class<?> b = other.paramTypes[idx];
			
			if (!a.getCanonicalName().equals(b.getCanonicalName())) {
				return false;
			}
		}
		
		if (this.returnType == null) {
			if (other.returnType != null) {
				return false;
			}
		} else if (!this.returnType.getCanonicalName().equals(
			other.returnType.getCanonicalName())) {
			return false;
		}
		return true;
	}
	
	@Override
	public String toString() {
		
		String param = "";
		
		int count = 0;
		for (Class<?> cls : this.paramTypes) {
			if (count == this.paramTypes.length - 1) {
				param = param + cls.getCanonicalName();
			} else {
				param = param + cls.getCanonicalName() + ", ";
			}
		}
		
		String result =
			this.returnType.getCanonicalName()
				+ " "
				+ this.methodName
				+ "("
				+ param
				+ ")";
		
		return result;
	}
}
