/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.driver;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;
import org.dyndns.nuda.mapper.driver.helper.ConStrRegexBean;
import org.dyndns.nuda.mapper.driver.helper.RealSubProtocolRegexBean;
import org.dyndns.nuda.tools.regex.RegexProcessor;
import org.dyndns.nuda.tools.util.StringUtil;

/**
 * 各種JDBCコネクション実装クラスをSQLInterfaceイベント対応化するための<br />
 * JDBCConnectionラッパーを生成するドライバクラスです
 * 
 * @author nkoseki
 * 
 */
public class SorMapDriver implements Driver {
	static {
		try {
			DriverManager.registerDriver(new SorMapDriver());
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}
	
	@Override
	public Connection connect(final String url, final Properties info)
			throws SQLException {
		if (this.acceptsURL(url)) {
			RegexProcessor p = new RegexProcessor();
			ConStrRegexBean bean =
				p.processBySingle(url, ConStrRegexBean.class);
			RealSubProtocolRegexBean subProtocolBean =
				p.processBySingle(url, RealSubProtocolRegexBean.class);
			String realURL = null;
			if (subProtocolBean.realSubProtocol != null) {
				
				realURL =
					StringUtil.format(
						"jdbc:{}://{}",
						subProtocolBean.realSubProtocol,
						bean.dir);
				
			} else {
				if (info != null) {
					if (info.containsKey("subProtocol")) {
						realURL =
							StringUtil.format(
								"jdbc:{}://{}",
								info.get("subProtocol"),
								bean.dir);
					}
				}
			}
			
			if (realURL != null) {
				try {
					Connection con0 =
						DriverManager.getConnection(realURL, info);
					
					con0 = new SQLInterfaceConnection(con0);
					
					return con0;
				} catch (SQLException e) {
					throw e;
				}
			} else {
				throw new SQLException("realURL IS NULL");
			}
		} else {
			return null;
		}
		
	}
	
	@Override
	public boolean acceptsURL(final String url) throws SQLException {
		RegexProcessor p = new RegexProcessor();
		ConStrRegexBean bean = p.processBySingle(url, ConStrRegexBean.class);
		if ("sormap".equals(bean.subProtocol)) {
			
			return true;
			
		} else {
			return false;
		}
	}
	
	@Override
	public DriverPropertyInfo[] getPropertyInfo(final String url,
			final Properties info) throws SQLException {
		RegexProcessor p = new RegexProcessor();
		
		RealSubProtocolRegexBean subProtocolBean =
			p.processBySingle(url, RealSubProtocolRegexBean.class);
		if (subProtocolBean.realSubProtocol != null) {
			info.put("subProtocol", subProtocolBean.realSubProtocol);
		} else {
			if (info != null) {
				if (info.containsKey("subProtocol")) {
					
				} else {
					throw new SQLException("subProtocol is NULL");
				}
			}
		}
		
		List<DriverPropertyInfo> infoList = new ArrayList<DriverPropertyInfo>();
		
		DriverPropertyInfo dp01 =
			new DriverPropertyInfo("user", info.getProperty("user"));
		DriverPropertyInfo dp02 =
			new DriverPropertyInfo("password", info.getProperty("password"));
		DriverPropertyInfo dp03 =
			new DriverPropertyInfo(
				"subProtocol",
				info.getProperty("subProtocol"));
		
		dp01.description = "username";
		dp01.required = true;
		
		dp02.description = "password";
		dp02.required = true;
		
		dp03.description = "sub_protocol";
		dp03.required = false;
		
		infoList.add(dp01);
		infoList.add(dp02);
		infoList.add(dp03);
		
		return infoList.toArray(new DriverPropertyInfo[infoList.size()]);
	}
	
	@Override
	public int getMajorVersion() {
		return 0;
	}
	
	@Override
	public int getMinorVersion() {
		return 0;
	}
	
	@Override
	public boolean jdbcCompliant() {
		return false;
	}
	
}
