/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.dyndns.nuda.logger.CommonLogger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * SQLXMLをJavaBeansに展開するためのSAXパーサです
 * 
 * @author nkoseki
 * 
 */
public class QueryXMLReader extends DefaultHandler {
	
	private int					currentScope			= SCOPE_INVALID;
	
	private static int			SCOPE_ROOT				= 1;
	private static int			SCOPE_STATEMENT			= 2;
	
	private static int			SCOPE_CONNECTION		= 3;
	private static int			SCOPE_CONNECTION_PARAM	= 4;
	
	private static int			SCOPE_INVALID			= -1;
	
	private static final String	QNAME_REPSERV_TASK		= "statements";
	private static final String	QNAME_TASK_ELEMENT		= "statement";
	
	private static final String	QNAME_CONNECTION		= "connection";
	private static final String	QNAME_CONNECTION_PARAM	= "param";
	
	public void changeScope(final String qName) {
		if (QNAME_REPSERV_TASK.equals(qName)) {
			this.currentScope = SCOPE_ROOT;
		} else if (QNAME_TASK_ELEMENT.equals(qName)) {
			this.currentScope = SCOPE_STATEMENT;
			
		} else if (QNAME_CONNECTION.equals(qName)) {
			this.currentScope = SCOPE_CONNECTION;
			
		} else if (QNAME_CONNECTION_PARAM.equals(qName)) {
			this.currentScope = SCOPE_CONNECTION_PARAM;
		} else {
			this.currentScope = SCOPE_INVALID;
		}
	}
	
	private List<QueryXMLBean>	resultList	= new ArrayList<QueryXMLBean>();
	
	private QueryXMLBean		context		= null;
	
	private ConnectionBean		conBean		= new ConnectionBean();
	
	public List<QueryXMLBean> getResult() {
		// Logger.getLogger("QueryXMLReader").info(this.resultList);
		return this.resultList;
	}
	
	public ConnectionBean getConnectionInfo() {
		return this.conBean;
	}
	
	@Override
	public void startElement(final String uri, final String localName,
			final String qName, final Attributes attributes)
			throws SAXException {
		this.changeScope(qName);
		
		if (this.currentScope == SCOPE_ROOT) {
			this.resultList = new ArrayList<QueryXMLBean>();
		} else if (this.currentScope == SCOPE_STATEMENT) {
			this.context = new QueryXMLBean();
			
			String id = attributes.getValue("id");
			String type = attributes.getValue("type");
			
			if (type == null || type.isEmpty()) {
				type = "OTHER";
			}
			
			this.context.setId(id);
			this.context.setType(type);
		} else if (this.currentScope == SCOPE_CONNECTION) {
			String url = attributes.getValue("url");
			this.conBean.url = url;
		} else if (this.currentScope == SCOPE_CONNECTION_PARAM) {
			String key = attributes.getValue("key");
			String value = attributes.getValue("value");
			
			this.conBean.prop.put(key, value);
		}
	}
	
	@Override
	public void endElement(final String uri, final String localName,
			final String qName) throws SAXException {
		
		this.changeScope(qName);
		
		if (this.currentScope == SCOPE_STATEMENT) {
			// Logger.getLogger("QueryXMLReader#endElement").info(this.context);
			this.resultList.add(this.context);
		}
		
		this.currentScope = SCOPE_INVALID;
	}
	
	@Override
	public void characters(final char[] ch, final int start, final int length)
			throws SAXException {
		
		if (this.currentScope == SCOPE_STATEMENT) {
			String value = new String(ch, start, length);
			
			// Logger.getLogger("QueryXMLReader#characters").info(value);
			// Logger.getLogger("QueryXMLReader#characters").info(
			// start + "/" + length);
			
			StringBuilder b = new StringBuilder();
			b.append(this.context.getSql()).append(value);
			
			this.context.setSql(b.toString());
		}
	}
	
	public void read(final InputStream is) {
		try {
			SAXParserFactory factory = SAXParserFactory.newInstance();
			SAXParser perser = factory.newSAXParser();
			
			try {
				perser.parse(is, this);
			} catch (IllegalArgumentException e) {
				throw new IOException("InputStream Is Null");
			}
			
		} catch (ParserConfigurationException e) {
			//			LoggerFactory.getLogger("QueryXMLReader").error("error", e);
			//			ここにはこないはず
			assert (false);
		} catch (SAXException e) {
			//			LoggerFactory.getLogger("QueryXMLReader").error("error", e);
			CommonLogger
				.getLoggerAdaptor()
				.getLogger("QueryXMLReader")
				.error("error(input:InputStream)", e);
			throw new IllegalArgumentException(e);
		} catch (IOException e) {
			CommonLogger
				.getLoggerAdaptor()
				.getLogger("QueryXMLReader")
				.error("error", e);
			
			throw new IllegalArgumentException(e);
		}
	}
	
	public void read(final File file) {
		try {
			SAXParserFactory factory = SAXParserFactory.newInstance();
			SAXParser perser = factory.newSAXParser();
			
			perser.parse(file, this);
		} catch (ParserConfigurationException e) {
			//			LoggerFactory.getLogger("QueryXMLReader").error("error", e);
			assert (false);
		} catch (SAXException e) {
			//			LoggerFactory.getLogger("QueryXMLReader").error("error", e);
			CommonLogger
				.getLoggerAdaptor()
				.getLogger("QueryXMLReader")
				.error("error(input:file)", e);
			throw new IllegalArgumentException(e);
		} catch (IOException e) {
			CommonLogger
				.getLoggerAdaptor()
				.getLogger("QueryXMLReader")
				.error("error", e);
			
			throw new IllegalArgumentException(e);
		}
	}
}
