/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.sormap.sample;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;

import org.dyndns.nuda.mapper.JDBCQueryHandler;
import org.dyndns.nuda.mapper.SQLInterfaceFactory;

public class TestMain {
	
	/**
	 * @param args
	 * @throws Exception
	 */
	public static void main(final String[] args) throws Exception {
		// JDBCコネクションを作成
		Connection con = DriverManager.getConnection("[Insert Connect String]");
		
		// SQLXMLインタフェースを生成
		// 第一引数：コネクションオブジェクト
		// 第二引数：SQLXMLインタフェースクラスオブジェクト
		SampleInterface intf =
			JDBCQueryHandler.getHandler(con, SampleInterface.class);
		
		/*
		 * SampleInterfaceに付与されているJDBCQueryアノテーションは
		 * sqlxml=org/dyndns/nuda/sormap/sample/query.xml
		 * となっているため
		 * このクラスのパッケージのquery.xmlにリンクする
		 */

		// データベースから結果セットを取得
		List<TestSchemeBean> resultList = intf.select();
		
		// リスト0番目のnameフィールドを変更
		resultList.get(0).setName("change");
		
		// 結果をDBに反映(UPDATE)
		intf.update(resultList.get(0));
		
		// リストで一括修正することも可能
		intf.update(resultList);
		
		TestSchemeBean newBean = new TestSchemeBean();
		
		// 新しいレコードをINSERT
		intf.insert(newBean);
		
		// 上記レコードをDELETE
		intf.delete(newBean);
		
		/*
		 * 注意：現状ではそれぞれのINSERT,UPDATE,DELETEごとに
		 * コミットされてしまう。
		 * 
		 * 次期バージョンで修正予定
		 */

		SQLInterfaceFactory
			.newInstance()
			.connection(null)
			.useAutoCommit(false)
			.useManualTransaction(false)
			.create(SampleInterface.class);
	}
	
}
