/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.s2;

import org.apache.log4j.Logger;
import org.dyndns.nuda.mapper.s2.S2Component;
import org.dyndns.nuda.mapper.s2.SQLInterfaceComponentDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.creator.ComponentCreatorImpl;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.convention.NamingConvention;

public class SQLInterfaceCreator
extends ComponentCreatorImpl {
    private Logger logger = Logger.getLogger(SQLInterfaceCreator.class);

    public SQLInterfaceCreator(NamingConvention namingConvention) {
        super(namingConvention);
        this.logger.info((Object)"\u521d\u671f\u5316");
        this.setNameSuffix("SqlIF");
        this.setInstanceDef(InstanceDefFactory.SINGLETON);
    }

    public NamingConvention getNamingConvention() {
        this.logger.info((Object)"getNamingConvertion");
        return super.getNamingConvention();
    }

    public ComponentDef createComponentDef(Class componentClass) {
        this.logger.info((Object)("createComponentDef(final Class componentClass):" + componentClass));
        String className = componentClass.getName();
        if (!className.toLowerCase().endsWith(this.getNameSuffix().toLowerCase())) {
            return null;
        }
        if (!componentClass.isAnnotationPresent(S2Component.class)) {
            return null;
        }
        if (!componentClass.isInterface()) {
            return null;
        }
        this.logger.info((Object)"check ok");
        SQLInterfaceComponentDef cd = new SQLInterfaceComponentDef();
        cd.setInterfaceClass(componentClass);
        cd.setComponentName(componentClass.getSimpleName());
        this.logger.info((Object)"create component def");
        return cd;
    }

    public ComponentDef createComponentDef(String componentName) {
        this.logger.info((Object)("createComponentDef(final String componentName):" + componentName));
        if (!componentName.toLowerCase().endsWith(this.getNameSuffix().toLowerCase())) {
            return null;
        }
        String[] packages = this.getNamingConvention().getRootPackageNames();
        Class<?> interfaceClass = null;
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String pack;
            String packageName = pack = stringArray[n2];
            String className = packageName + "." + "dao" + "." + componentName;
            try {
                interfaceClass = Class.forName(className);
                this.logger.info((Object)className);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++n2;
            }
        }
        if (interfaceClass == null) {
            return null;
        }
        return this.createComponentDef(interfaceClass);
    }
}

