/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.connection;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.dyndns.nuda.mapper.SQLInterfaceBean;
import org.dyndns.nuda.mapper.connection.ArrayImpl;
import org.dyndns.nuda.mapper.connection.BlobImpl;
import org.dyndns.nuda.mapper.connection.ClobImpl;
import org.dyndns.nuda.mapper.connection.InputStreamImpl;
import org.dyndns.nuda.mapper.connection.NClobImpl;
import org.dyndns.nuda.mapper.connection.PreparedStatementImpl;
import org.dyndns.nuda.mapper.connection.ReaderImpl;
import org.dyndns.nuda.mapper.connection.RowIdImpl;
import org.dyndns.nuda.mapper.connection.SQLInterfacePreparedStatement;
import org.dyndns.nuda.mapper.connection.SQLXMLImpl;
import org.dyndns.nuda.tools.Listener;
import org.dyndns.nuda.tools.MethodCall;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SQLInterfacePreparedStatementTest
extends TestCase {
    private SQLInterfaceBean intfBean = null;
    private SQLInterfacePreparedStatement pstmt = null;
    private MethodCall methodCall = null;

    @Before
    public void setUp() throws Exception {
        HashMap<Integer, String> map;
        SQLInterfaceBean bean = new SQLInterfaceBean();
        bean.id = "test";
        bean.sqlStr = "sql";
        bean.type = "INSERT";
        bean.map = map = new HashMap<Integer, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(1, "id");
                this.put(2, "name");
                this.put(3, "curdate");
            }
        };
        this.intfBean = bean;
        this.methodCall = MethodCall.newInstance();
        this.pstmt = new SQLInterfacePreparedStatement(new PreparedStatementImpl(this.methodCall));
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetInterfaceBean() {
        this.pstmt.setInterfaceBean(this.intfBean);
        SQLInterfaceBean actual = this.pstmt.getInterfaceBean();
        Assert.assertEquals((Object)this.intfBean, (Object)actual);
    }

    @Test
    public void testExecuteQueryString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"executeQuery[String]", (String)method);
                }
            });
            this.pstmt.executeQuery("");
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUnwrap() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"unwrap[Class<T>]", (String)method);
                }
            });
            this.pstmt.unwrap(null);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteQuery() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"executeQuery[]", (String)method);
                }
            });
            this.pstmt.executeQuery();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteUpdateString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"executeUpdate[String]", (String)method);
                }
            });
            this.pstmt.executeUpdate("");
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIsWrapperFor() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"isWrapperFor[Class<T>]", (String)method);
                }
            });
            this.pstmt.isWrapperFor(null);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteUpdate() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"executeUpdate[]", (String)method);
                }
            });
            this.pstmt.executeUpdate();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testClose() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"close[]", (String)method);
                }
            });
            this.pstmt.close();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetNullIntInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setNull[int,int]", (String)method);
                }
            });
            this.pstmt.setNull(0, 0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetMaxFieldSize() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getMaxFieldSize[]", (String)method);
                }
            });
            this.pstmt.getMaxFieldSize();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetBoolean() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setBoolean[int,boolean]", (String)method);
                }
            });
            this.pstmt.setBoolean(0, true);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetMaxFieldSize() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setMaxFieldSize[int]", (String)method);
                }
            });
            this.pstmt.setMaxFieldSize(0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetByte() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setByte[int,byte]", (String)method);
                }
            });
            this.pstmt.setByte(0, (byte)16);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetShort() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setShort[int,short]", (String)method);
                }
            });
            this.pstmt.setShort(0, (short)0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetMaxRows() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getMaxRows[]", (String)method);
                }
            });
            this.pstmt.getMaxRows();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setInt[int,int]", (String)method);
                }
            });
            this.pstmt.setInt(0, 1);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetMaxRows() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setMaxRows[int]", (String)method);
                }
            });
            this.pstmt.setMaxRows(0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetLong() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setLong[int,long]", (String)method);
                }
            });
            this.pstmt.setLong(0, 0L);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetEscapeProcessing() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setEscapeProcessing[boolean]", (String)method);
                }
            });
            this.pstmt.setEscapeProcessing(true);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetFloat() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setFloat[int,float]", (String)method);
                }
            });
            this.pstmt.setFloat(0, 0.0f);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetQueryTimeout() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getQueryTimeout[]", (String)method);
                }
            });
            this.pstmt.getQueryTimeout();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetDouble() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setDouble[int,double]", (String)method);
                }
            });
            this.pstmt.setDouble(0, 0.0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetQueryTimeout() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setQueryTimeout[int]", (String)method);
                }
            });
            this.pstmt.setQueryTimeout(0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetBigDecimal() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setBigDecimal[int,BigDecimal]", (String)method);
                }
            });
            this.pstmt.setBigDecimal(0, new BigDecimal(0));
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancel() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"cancel[]", (String)method);
                }
            });
            this.pstmt.cancel();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setString[int,String]", (String)method);
                }
            });
            this.pstmt.setString(0, "");
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetWarnings() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getWarnings[]", (String)method);
                }
            });
            this.pstmt.getWarnings();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetBytes() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setBytes[int,byte[]]", (String)method);
                }
            });
            this.pstmt.setBytes(0, new byte[0]);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testClearWarnings() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"clearWarnings[]", (String)method);
                }
            });
            this.pstmt.clearWarnings();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetDateIntDate() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setDate[int,Date]", (String)method);
                }
            });
            this.pstmt.setDate(0, new Date(0L));
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetCursorName() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setCursorName[String]", (String)method);
                }
            });
            this.pstmt.setCursorName("");
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetTimeIntTime() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setTime[int,Time]", (String)method);
                }
            });
            Time t = new Time(0L);
            this.pstmt.setTime(0, t);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetTimestampIntTimestamp() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setTimestamp[int,Timestamp]", (String)method);
                }
            });
            Timestamp t = new Timestamp(0L);
            this.pstmt.setTimestamp(0, t);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"execute[String]", (String)method);
                }
            });
            this.pstmt.execute("");
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetAsciiStreamIntInputStreamInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setAsciiStream[int,InputStream,int]", (String)method);
                }
            });
            this.pstmt.setAsciiStream(0, (InputStream)null, 0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetResultSet() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getResultSet[]", (String)method);
                }
            });
            this.pstmt.getResultSet();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetUnicodeStream() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setUnicodeStream[int,InputStream,int]", (String)method);
                }
            });
            this.pstmt.setUnicodeStream(0, null, 0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetUpdateCount() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getUpdateCount[]", (String)method);
                }
            });
            this.pstmt.getUpdateCount();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetMoreResults() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getMoreResults[]", (String)method);
                }
            });
            this.pstmt.getMoreResults();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetBinaryStreamIntInputStreamInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setBinaryStream[int,InputStream,int]", (String)method);
                }
            });
            this.pstmt.setBinaryStream(0, (InputStream)null, 0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetFetchDirection() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setFetchDirection[int]", (String)method);
                }
            });
            this.pstmt.setFetchDirection(0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testClearParameters() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"clearParameters[]", (String)method);
                }
            });
            this.pstmt.clearParameters();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetFetchDirection() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getFetchDirection[]", (String)method);
                }
            });
            this.pstmt.getFetchDirection();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetObjectIntObjectInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setObject[int,Object,int]", (String)method);
                }
            });
            this.pstmt.setObject(0, new Object(), 0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetFetchSize() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setFetchSize[int]", (String)method);
                }
            });
            this.pstmt.setFetchSize(0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetFetchSize() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getFetchSize[]", (String)method);
                }
            });
            this.pstmt.getFetchSize();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetObjectIntObject() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setObject[int,Object]", (String)method);
                }
            });
            this.pstmt.setObject(0, new Object());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetResultSetConcurrency() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getResultSetConcurrency[]", (String)method);
                }
            });
            this.pstmt.getResultSetConcurrency();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetResultSetType() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getResultSetType[]", (String)method);
                }
            });
            this.pstmt.getResultSetType();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAddBatchString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"addBatch[String]", (String)method);
                }
            });
            this.pstmt.addBatch("");
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testClearBatch() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"clearBatch[]", (String)method);
                }
            });
            this.pstmt.clearBatch();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecute() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"execute[]", (String)method);
                }
            });
            this.pstmt.execute();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteBatch() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"executeBatch[]", (String)method);
                }
            });
            this.pstmt.executeBatch();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAddBatch() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"addBatch[]", (String)method);
                }
            });
            this.pstmt.addBatch();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetCharacterStreamIntReaderInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setCharacterStream[int,Reader,int]", (String)method);
                }
            });
            this.pstmt.setCharacterStream(0, (Reader)null, 0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetRef() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setRef[int,Ref]", (String)method);
                }
            });
            Ref r = new Ref(){

                @Override
                public String getBaseTypeName() throws SQLException {
                    return null;
                }

                @Override
                public Object getObject(Map<String, Class<?>> map) throws SQLException {
                    return null;
                }

                @Override
                public Object getObject() throws SQLException {
                    return null;
                }

                @Override
                public void setObject(Object value) throws SQLException {
                }
            };
            this.pstmt.setRef(0, r);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetConnection() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getConnection[]", (String)method);
                }
            });
            this.pstmt.getConnection();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetBlobIntBlob() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setBlob[int,Blob]", (String)method);
                }
            });
            this.pstmt.setBlob(0, new BlobImpl());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetClobIntClob() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setClob[int,Clob]", (String)method);
                }
            });
            this.pstmt.setClob(0, new ClobImpl());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetMoreResultsInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getMoreResults[int]", (String)method);
                }
            });
            this.pstmt.getMoreResults(0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetArray() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setArray[int,Array]", (String)method);
                }
            });
            this.pstmt.setArray(0, new ArrayImpl());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetMetaData() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getMetaData[]", (String)method);
                }
            });
            this.pstmt.getMetaData();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetGeneratedKeys() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getGeneratedKeys[]", (String)method);
                }
            });
            this.pstmt.getGeneratedKeys();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetDateIntDateCalendar() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setDate[int,Date,Calendar]", (String)method);
                }
            });
            this.pstmt.setDate(0, new Date(0L), Calendar.getInstance());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteUpdateStringInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"executeUpdate[String,int]", (String)method);
                }
            });
            this.pstmt.executeUpdate("", 0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetTimeIntTimeCalendar() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setTime[int,Time,Calendar]", (String)method);
                }
            });
            this.pstmt.setTime(0, new Time(0L), Calendar.getInstance());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteUpdateStringIntArray() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"executeUpdate[String,int[]]", (String)method);
                }
            });
            this.pstmt.executeUpdate("", new int[0]);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetTimestampIntTimestampCalendar() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setTimestamp[int,Timestamp,Calendar]", (String)method);
                }
            });
            this.pstmt.setTimestamp(0, new Timestamp(0L), Calendar.getInstance());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetNullIntIntString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setNull[int,int,String]", (String)method);
                }
            });
            this.pstmt.setNull(0, 0, "");
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteUpdateStringStringArray() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"executeUpdate[String,String[]]", (String)method);
                }
            });
            this.pstmt.executeUpdate("", new String[0]);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteStringInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"execute[String,int]", (String)method);
                }
            });
            this.pstmt.execute("", 0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetURL() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setURL[int,URL]", (String)method);
                }
            });
            this.pstmt.setURL(0, new URL("http://localhost/main"));
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
        catch (MalformedURLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetParameterMetaData() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getParameterMetaData[]", (String)method);
                }
            });
            this.pstmt.getParameterMetaData();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetRowId() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setRowId[int,RowId]", (String)method);
                }
            });
            this.pstmt.setRowId(0, new RowIdImpl());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteStringIntArray() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"execute[String,int[]]", (String)method);
                }
            });
            this.pstmt.execute("", new int[0]);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetNString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setNString[int,String]", (String)method);
                }
            });
            this.pstmt.setNString(0, "");
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetNCharacterStreamIntReaderLong() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setNCharacterStream[int,Reader,long]", (String)method);
                }
            });
            this.pstmt.setNCharacterStream(0, null, 0L);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExecuteStringStringArray() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"execute[String,String[]]", (String)method);
                }
            });
            this.pstmt.execute("", new String[0]);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetNClobIntNClob() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setNClob[int,NClob]", (String)method);
                }
            });
            this.pstmt.setNClob(0, new NClobImpl());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetClobIntReaderLong() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setClob[int,Reader,long]", (String)method);
                }
            });
            this.pstmt.setClob(0, null, 0L);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetResultSetHoldability() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getResultSetHoldability[]", (String)method);
                }
            });
            this.pstmt.getResultSetHoldability();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetBlobIntInputStreamLong() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setBlob[int,InputStream,long]", (String)method);
                }
            });
            this.pstmt.setBlob(0, null, 0L);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIsClosed() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"isClosed[]", (String)method);
                }
            });
            this.pstmt.isClosed();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetPoolable() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setPoolable[boolean]", (String)method);
                }
            });
            this.pstmt.setPoolable(true);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetNClobIntReaderLong() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setNClob[int,Reader,long]", (String)method);
                }
            });
            this.pstmt.setNClob(0, null, 0L);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIsPoolable() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"isPoolable[]", (String)method);
                }
            });
            this.pstmt.isPoolable();
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetSQLXML() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setSQLXML[int,SQLXML]", (String)method);
                }
            });
            this.pstmt.setSQLXML(0, new SQLXMLImpl());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetObjectIntObjectIntInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setObject[int,Object,int,int]", (String)method);
                }
            });
            this.pstmt.setObject(0, new Object(), 0, 0);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetAsciiStreamIntInputStreamLong() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setAsciiStream[int,InputStream,long]", (String)method);
                }
            });
            this.pstmt.setAsciiStream(0, null, 0L);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetBinaryStreamIntInputStreamLong() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setBinaryStream[int,InputStream,long]", (String)method);
                }
            });
            this.pstmt.setBinaryStream(0, null, 0L);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetCharacterStreamIntReaderLong() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setCharacterStream[int,Reader,long]", (String)method);
                }
            });
            this.pstmt.setCharacterStream(0, null, 0L);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetAsciiStreamIntInputStream() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setAsciiStream[int,InputStream]", (String)method);
                }
            });
            this.pstmt.setAsciiStream(0, null);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetBinaryStreamIntInputStream() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setBinaryStream[int,InputStream]", (String)method);
                }
            });
            this.pstmt.setBinaryStream(0, null);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetCharacterStreamIntReader() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setCharacterStream[int,Reader]", (String)method);
                }
            });
            this.pstmt.setCharacterStream(0, null);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetNCharacterStreamIntReader() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setNCharacterStream[int,Reader]", (String)method);
                }
            });
            this.pstmt.setNCharacterStream(0, null);
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetClobIntReader() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setClob[int,Reader]", (String)method);
                }
            });
            this.pstmt.setClob(0, new ReaderImpl());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetBlobIntInputStream() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setBlob[int,InputStream]", (String)method);
                }
            });
            this.pstmt.setBlob(0, new InputStreamImpl());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetNClobIntReader() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setNClob[int,Reader]", (String)method);
                }
            });
            this.pstmt.setNClob(0, new ReaderImpl());
        }
        catch (SQLException e) {
            SQLInterfacePreparedStatementTest.fail((String)e.getMessage());
        }
    }
}

