/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.dyndns.nuda.mapper.DaoHelper;
import org.dyndns.nuda.mapper.ResultSetStab;
import org.dyndns.nuda.mapper.SQLMapperException;
import org.dyndns.nuda.mapper.TestBean;
import org.dyndns.nuda.mapper.TestBean02;
import org.dyndns.nuda.mapper.TestBean03;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DaoHelperTest
extends TestCase {
    private ResultSetStab stab = null;

    @Before
    public void setUp() throws Exception {
        String caseName = this.getName();
        if ("testConvertResult01_Integer".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, 123);
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult01_IntegerPremitive".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, 123);
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult02_String".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, "123");
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult03_java_util_Date".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, new Date(0L));
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult04_java_sql_Date".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, new Date(0L));
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult05_Long".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, 12345L);
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult05_LongPremitive".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, 12345L);
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult06_Double".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, 0.12345);
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult06_DoublePremitive".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, 0.12345);
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult07_BigInteger".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, BigInteger.valueOf(123456L));
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult08_BigDecimal".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, BigDecimal.valueOf(0.123456));
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult09_Boolean".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, false);
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult09_BooleanPremitive".equals(caseName)) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(1, false);
            this.stab = new ResultSetStab("", map, null);
        } else if ("testConvertResult01_BeanInteger".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult02_BeanString".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult03_Beanjava_util_Date".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            map.put("date", new Date(0L));
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            columnMap.put(3, "date");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult04_Beanjava_sql_Date".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            map.put("date", new Date(0L));
            map.put("date2", new Date(0L));
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            columnMap.put(3, "date");
            columnMap.put(4, "date2");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult05_BeanLong".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            map.put("date", new Date(0L));
            map.put("date2", new Date(0L));
            map.put("time", 54321L);
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            columnMap.put(3, "date");
            columnMap.put(4, "date2");
            columnMap.put(5, "time");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult06_BeanDouble".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            map.put("date", new Date(0L));
            map.put("date2", new Date(0L));
            map.put("time", 54321L);
            map.put("value", 0.54321);
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            columnMap.put(3, "date");
            columnMap.put(4, "date2");
            columnMap.put(5, "time");
            columnMap.put(6, "value");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult07_BeanBigInteger".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            map.put("date", new Date(0L));
            map.put("date2", new Date(0L));
            map.put("time", 54321L);
            map.put("value", 0.54321);
            map.put("invalidValue", BigInteger.valueOf(1234L));
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            columnMap.put(3, "date");
            columnMap.put(4, "date2");
            columnMap.put(5, "time");
            columnMap.put(6, "value");
            columnMap.put(7, "invalidValue");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult08_BeanBigDecimal".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            map.put("date", new Date(0L));
            map.put("date2", new Date(0L));
            map.put("time", 54321L);
            map.put("value", 0.54321);
            map.put("currency", BigDecimal.valueOf(0.54321));
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            columnMap.put(3, "date");
            columnMap.put(4, "date2");
            columnMap.put(5, "time");
            columnMap.put(6, "value");
            columnMap.put(7, "currency");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult09_BeanBoolean".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            map.put("date", new Date(0L));
            map.put("date2", new Date(0L));
            map.put("time", 54321L);
            map.put("value", 0.54321);
            map.put("currency", BigDecimal.valueOf(0.54321));
            map.put("flg", false);
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            columnMap.put(3, "date");
            columnMap.put(4, "date2");
            columnMap.put(5, "time");
            columnMap.put(6, "value");
            columnMap.put(7, "currency");
            columnMap.put(8, "flg");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult09_BeanUpperCase".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            map.put("date", new Date(0L));
            map.put("date2", new Date(0L));
            map.put("time", 54321L);
            map.put("value", 0.54321);
            map.put("currency", BigDecimal.valueOf(0.54321));
            map.put("flg", false);
            map.put("UPPER_CASE", "upper case test");
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            columnMap.put(3, "date");
            columnMap.put(4, "date2");
            columnMap.put(5, "time");
            columnMap.put(6, "value");
            columnMap.put(7, "currency");
            columnMap.put(8, "flg");
            columnMap.put(9, "UPPER_CASE");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult10_Bean_IllegalAccess".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            map.put("date", new Date(0L));
            map.put("date2", new Date(0L));
            map.put("time", 54321L);
            map.put("value", 0.54321);
            map.put("currency", BigDecimal.valueOf(0.54321));
            map.put("flg", false);
            map.put("invalidValue02", "abc");
            map.put("UPPER_CASE", "upper case test");
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            columnMap.put(3, "date");
            columnMap.put(4, "date2");
            columnMap.put(5, "time");
            columnMap.put(6, "value");
            columnMap.put(7, "currency");
            columnMap.put(8, "flg");
            columnMap.put(9, "UPPER_CASE");
            columnMap.put(10, "invalidValue02");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult10_Bean_Instantiation".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            this.stab = new ResultSetStab("", null, map, columnMap);
        } else if ("testConvertResult10_Bean_InvocationTargetException".equals(caseName)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", 12345);
            map.put("name", "Sormap Test");
            map.put("test", "Sormap Test");
            HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
            columnMap.put(1, "seq");
            columnMap.put(2, "name");
            columnMap.put(3, "test");
            this.stab = new ResultSetStab("", null, map, columnMap);
        }
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testConvertResult01_Integer() {
        int result = DaoHelper.convertResult(this.stab, Integer.class);
        Assert.assertEquals((int)123, (int)result);
    }

    @Test
    public void testConvertResult01_IntegerPremitive() {
        int result = DaoHelper.convertResult(this.stab, Integer.TYPE);
        Assert.assertEquals((int)123, (int)result);
    }

    @Test
    public void testConvertResult02_String() {
        String result = DaoHelper.convertResult(this.stab, String.class);
        Assert.assertEquals((String)"123", (String)result);
    }

    @Test
    public void testConvertResult03_java_util_Date() {
        java.util.Date result = DaoHelper.convertResult(this.stab, java.util.Date.class);
        Assert.assertEquals((Object)new java.util.Date(0L), (Object)result);
    }

    @Test
    public void testConvertResult04_java_sql_Date() {
        Date result = DaoHelper.convertResult(this.stab, Date.class);
        Assert.assertEquals((Object)new Date(0L), (Object)result);
    }

    @Test
    public void testConvertResult05_Long() {
        long result = DaoHelper.convertResult(this.stab, Long.class);
        Assert.assertEquals((long)12345L, (long)result);
    }

    @Test
    public void testConvertResult05_LongPremitive() {
        long result = DaoHelper.convertResult(this.stab, Long.TYPE);
        Assert.assertEquals((long)12345L, (long)result);
    }

    @Test
    public void testConvertResult06_Double() {
        double result = DaoHelper.convertResult(this.stab, Double.class);
        Assert.assertEquals((Object)0.12345, (Object)result);
    }

    @Test
    public void testConvertResult06_DoublePremitive() {
        double result = DaoHelper.convertResult(this.stab, Double.TYPE);
        Assert.assertEquals((Object)0.12345, (Object)result);
    }

    @Test
    public void testConvertResult07_BigInteger() {
        try {
            DaoHelper.convertResult(this.stab, BigInteger.class);
            Assert.fail();
        }
        catch (Exception e) {
            if (e instanceof SQLMapperException) {
                Assert.assertTrue((boolean)true);
            }
            Assert.fail();
        }
    }

    @Test
    public void testConvertResult08_BigDecimal() {
        BigDecimal result = DaoHelper.convertResult(this.stab, BigDecimal.class);
        Assert.assertEquals((Object)BigDecimal.valueOf(0.123456), (Object)result);
    }

    @Test
    public void testConvertResult09_Boolean() {
        boolean result = DaoHelper.convertResult(this.stab, Boolean.class);
        Assert.assertEquals((boolean)false, (boolean)result);
    }

    @Test
    public void testConvertResult09_BooleanPremitive() {
        boolean result = DaoHelper.convertResult(this.stab, Boolean.TYPE);
        Assert.assertEquals((boolean)false, (boolean)result);
    }

    @Test
    public void testConvertResult01_BeanInteger() {
        TestBean bean = DaoHelper.convertResult(this.stab, TestBean.class);
        Assert.assertEquals((int)12345, (int)bean.getSeq());
    }

    @Test
    public void testConvertResult02_BeanString() {
        TestBean bean = DaoHelper.convertResult(this.stab, TestBean.class);
        Assert.assertEquals((String)"Sormap Test", (String)bean.getName());
    }

    @Test
    public void testConvertResult03_Beanjava_util_Date() {
        TestBean bean = DaoHelper.convertResult(this.stab, TestBean.class);
        Assert.assertEquals((Object)new java.util.Date(0L), (Object)bean.getDate());
    }

    @Test
    public void testConvertResult04_Beanjava_sql_Date() {
        TestBean bean = DaoHelper.convertResult(this.stab, TestBean.class);
        Assert.assertEquals((Object)new Date(0L), (Object)bean.getDate2());
    }

    @Test
    public void testConvertResult05_BeanLong() {
        TestBean bean = DaoHelper.convertResult(this.stab, TestBean.class);
        Assert.assertEquals((long)54321L, (long)bean.getTime());
    }

    @Test
    public void testConvertResult06_BeanDouble() {
        TestBean bean = DaoHelper.convertResult(this.stab, TestBean.class);
        Assert.assertEquals((Object)0.54321, (Object)bean.getValue());
    }

    @Test
    public void testConvertResult07_BeanBigInteger() {
        try {
            DaoHelper.convertResult(this.stab, TestBean.class);
            Assert.fail();
        }
        catch (Exception e) {
            if (e instanceof SQLMapperException) {
                Assert.assertTrue((boolean)true);
            }
            Assert.fail();
        }
    }

    @Test
    public void testConvertResult08_BeanBigDecimal() {
        TestBean bean = DaoHelper.convertResult(this.stab, TestBean.class);
        Assert.assertEquals((Object)BigDecimal.valueOf(0.54321), (Object)bean.getCurrency());
    }

    @Test
    public void testConvertResult09_BeanBoolean() {
        TestBean bean = DaoHelper.convertResult(this.stab, TestBean.class);
        Assert.assertEquals((boolean)false, (boolean)bean.isFlg());
    }

    @Test
    public void testConvertResult09_BeanUpperCase() {
        TestBean bean = DaoHelper.convertResult(this.stab, TestBean.class);
        Assert.assertEquals((String)"upper case test", (String)bean.getUpper_case());
    }

    @Test
    public void testConvertResult10_Bean_IllegalAccess() {
        try {
            DaoHelper.convertResult(this.stab, TestBean.class);
            Assert.assertTrue((boolean)true);
        }
        catch (Exception e) {
            if (e instanceof SQLMapperException) {
                Throwable e2 = e.getCause();
                if (e2 instanceof IllegalAccessException) {
                    Assert.assertTrue((boolean)true);
                } else {
                    Assert.fail();
                }
            }
            Assert.fail();
        }
    }

    @Test
    public void testConvertResult10_Bean_Instantiation() {
        try {
            DaoHelper.convertResult(this.stab, TestBean02.class);
            Assert.fail();
        }
        catch (Exception e) {
            if (e instanceof SQLMapperException) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InstantiationException) {
                    Assert.assertTrue((boolean)true);
                } else {
                    Assert.fail((String)e.getMessage());
                }
            }
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConvertResult10_Bean_InvocationTargetException() {
        try {
            DaoHelper.convertResult(this.stab, TestBean03.class);
            Assert.fail();
        }
        catch (Exception e) {
            if (e instanceof SQLMapperException) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InvocationTargetException) {
                    Assert.fail((String)e.getMessage());
                } else {
                    Assert.assertEquals((String)"error", (String)e2.getMessage());
                }
            }
            Assert.fail((String)e.getMessage());
        }
    }
}

