/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.sql.editor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dyndns.nuda.mapper.QueryCondition;
import org.dyndns.nuda.mapper.sql.editor.AutoSQLEditorResolver;
import org.dyndns.nuda.mapper.sql.editor.SQLEditorResolver;

public class ConditionedSQLEditorResolver
implements SQLEditorResolver {
    private static final String conditionPatternStr = "#@condition#";
    private static final Pattern conditionPattern = Pattern.compile("#@condition#");

    @Override
    public boolean accept(Object[] args, String sql) {
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (args != null && args.length > 1 && args[1] instanceof QueryCondition) {
            Matcher matcher = conditionPattern.matcher(sql);
            return matcher.find();
        }
        return false;
    }

    @Override
    public String editSql(Object[] args, String sql) {
        if (sql == null || sql.isEmpty()) {
            return "";
        }
        if (args != null && args.length > 1) {
            Object obj = args[1];
            if (args[1] instanceof QueryCondition) {
                Matcher matcher = conditionPattern.matcher(sql);
                if (matcher.find()) {
                    QueryCondition condition = (QueryCondition)obj;
                    String conditionStr = condition.renderCondition();
                    String result = sql.replace(conditionPatternStr, conditionStr);
                    return result;
                }
                return sql;
            }
        }
        return sql;
    }

    public void init() {
        AutoSQLEditorResolver.addResolver(this);
    }
}

