/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dyndns.nuda.mapper.SQLContainer;
import org.dyndns.nuda.mapper.SQLContainerImpl;
import org.dyndns.nuda.mapper.parser.AutoSQLParser;
import org.dyndns.nuda.mapper.parser.QUERY_TYPE;
import org.dyndns.nuda.mapper.parser.SQLParser;

public class InsertSQLParser
implements SQLParser {
    private static final String QST = "?";
    private static final String SPACE = " ";
    private static final String BLANK = "";
    public static final int FLAGS = 40;
    private static final String p1InsStr = "((\\d+|'.*?')\\s*?(/\\*.+?\\*/))";
    private static final Pattern P1INS = Pattern.compile("((\\d+|'.*?')\\s*?(/\\*.+?\\*/))", 40);
    private static final String p2InsStr = "((\\S+?\\s*|'.+')\\s*?/\\*\\s*?(.+?)\\s*?\\*/)";
    private static final Pattern P2INS = Pattern.compile("((\\S+?\\s*|'.+')\\s*?/\\*\\s*?(.+?)\\s*?\\*/)", 40);
    private static final String insertStatementPatternStr = "\\s*(insert|INSERT)\\s+?(\\s*?\\S+?\\s*?)+";
    private static final Pattern insertStatementPattern = Pattern.compile("\\s*(insert|INSERT)\\s+?(\\s*?\\S+?\\s*?)+", 42);

    @Override
    public SQLContainer parse(String queryId, String queryType, String sql) {
        if (!this.accept(queryType, sql)) {
            return null;
        }
        String source = sql;
        Matcher m = P1INS.matcher(source);
        String result0 = BLANK;
        HashMap<Integer, String> matchMap = new HashMap<Integer, String>();
        int matchIndex = 0;
        while (m.find()) {
            int startRegion = m.regionStart();
            int endRegion = m.regionEnd();
            Matcher subMatcher = m.region(startRegion, endRegion);
            subMatcher.usePattern(P2INS);
            while (subMatcher.find()) {
                String result2;
                String matchResult = subMatcher.group(3);
                matchMap.put(matchIndex + 1, matchResult.replace(SPACE, BLANK));
                result0 = result2 = subMatcher.replaceFirst(QST);
                subMatcher.reset(result2);
                ++matchIndex;
            }
        }
        if (result0.isEmpty()) {
            result0 = source;
        }
        SQLContainerImpl c = new SQLContainerImpl(queryId, QUERY_TYPE.valueOf(queryType), result0);
        for (Map.Entry entry : matchMap.entrySet()) {
            c.put((Integer)entry.getKey(), (String)entry.getValue());
        }
        return c;
    }

    @Override
    public boolean accept(String queryType, String sql) {
        if (queryType == null) {
            return false;
        }
        if (queryType.isEmpty()) {
            return false;
        }
        if (!queryType.equals(QUERY_TYPE.INSERT.toString())) {
            return false;
        }
        if (sql == null) {
            return false;
        }
        if (sql.isEmpty()) {
            return false;
        }
        return this.checkStatement(sql);
    }

    private boolean checkStatement(String sql) {
        if (sql == null) {
            return false;
        }
        if (sql.isEmpty()) {
            return false;
        }
        Matcher matcher = insertStatementPattern.matcher(sql);
        return matcher.matches();
    }

    public void init() {
        AutoSQLParser.addParser(this);
    }
}

