/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.paramchecker;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.dyndns.nuda.mapper.paramchecker.NOPParameterChecker;
import org.dyndns.nuda.mapper.paramchecker.ParameterCheckResult;
import org.dyndns.nuda.mapper.paramchecker.ParameterCheckResultImpl;
import org.dyndns.nuda.mapper.paramchecker.ParameterChecker;
import org.dyndns.nuda.mapper.paramchecker.ParameterCheckerImpl;

public class AutoParameterChecker
implements ParameterChecker {
    private static ParameterChecker me;
    private List<ParameterChecker> checkList = new ArrayList<ParameterChecker>();

    private AutoParameterChecker() {
        this.checkList.add(new ParameterCheckerImpl());
        this.checkList.add(new NOPParameterChecker());
    }

    public static ParameterChecker getInstance() {
        if (me == null) {
            me = new AutoParameterChecker();
        }
        return me;
    }

    @Override
    public ParameterCheckResult checkParameter(Method method, Object[] args) {
        for (ParameterChecker checker : this.checkList) {
            ParameterCheckResult r = checker.checkParameter(method, args);
            if (r.isValid()) continue;
            return r;
        }
        return new ParameterCheckResultImpl(true);
    }
}

