/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.connection;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dyndns.nuda.mapper.SQLInterfaceBean;
import org.dyndns.nuda.mapper.connection.SQLInterfacePreparedStatement;
import org.dyndns.nuda.mapper.event.SQLInterfaceEvent;
import org.dyndns.nuda.mapper.event.SQLInterfaceEventProcessor;
import org.dyndns.nuda.mapper.event.implementation.ManualTransactionEvent;
import org.dyndns.nuda.mapper.helper.CommandDataPair;

public class SQLInterfaceConnection
implements Connection {
    private Connection con = null;
    private boolean useManualTransaction = false;
    private List<CommandDataPair> commandList = new LinkedList<CommandDataPair>();
    private SQLInterfaceEvent currentEvent;

    public void addCommand(CommandDataPair pair) {
        this.commandList.add(pair);
    }

    public Connection getSourceConnection() {
        return this.con;
    }

    public void setSourceConnection(Connection con) {
        this.con = con;
    }

    public boolean isUseManualTransaction() {
        return this.useManualTransaction;
    }

    public void setUseManualTransaction(boolean useManualTransaction) {
        this.useManualTransaction = useManualTransaction;
    }

    public SQLInterfaceConnection(Connection con) {
        this.con = con;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.con.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.con.isWrapperFor(iface);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.con.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement p = this.con.prepareStatement(sql);
        SQLInterfacePreparedStatement pstmt = new SQLInterfacePreparedStatement(p);
        return pstmt;
    }

    public PreparedStatement prepareStatement(SQLInterfaceBean intfBean) throws SQLException {
        PreparedStatement p = this.con.prepareStatement(intfBean.sqlStr);
        SQLInterfacePreparedStatement pstmt = new SQLInterfacePreparedStatement(p);
        pstmt.setInterfaceBean(intfBean);
        return pstmt;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.con.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.con.nativeSQL(sql);
    }

    public void setCurrentEvent(SQLInterfaceEvent event) {
        this.currentEvent = event;
    }

    public SQLInterfaceEvent getCurrentEvent() {
        return this.currentEvent;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.con.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        if (this.getAutoCommit()) {
            return;
        }
        this.con.commit();
        if (this.isUseManualTransaction()) {
            ManualTransactionEvent ev = new ManualTransactionEvent();
            for (CommandDataPair pair : this.commandList) {
                ev.pair.add(pair);
            }
            ev.state = "commit";
            SQLInterfaceEventProcessor.newInstance().broadcast(ev);
            this.commandList.clear();
        }
    }

    public void commitWith(SQLInterfaceEvent event) throws SQLException {
        this.con.commit();
        if (event != null) {
            SQLInterfaceEventProcessor.newInstance().broadcast(event);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.con.rollback();
        if (this.useManualTransaction) {
            ManualTransactionEvent ev = new ManualTransactionEvent();
            for (CommandDataPair pair : this.commandList) {
                ev.pair.add(pair);
            }
            ev.state = "rollback";
            SQLInterfaceEventProcessor.newInstance().broadcast(ev);
            this.commandList.clear();
        }
    }

    public void rollbackWith(SQLInterfaceEvent event) throws SQLException {
        this.con.rollback();
        if (event != null) {
            SQLInterfaceEventProcessor.newInstance().broadcast(event);
        }
    }

    @Override
    public void close() throws SQLException {
        this.con.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.con.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.con.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.con.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement p = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return new SQLInterfacePreparedStatement(p);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.con.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.con.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.con.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.con.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.con.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement p = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return new SQLInterfacePreparedStatement(p);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement p = this.con.prepareStatement(sql, autoGeneratedKeys);
        return new SQLInterfacePreparedStatement(p);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement p = this.con.prepareStatement(sql, columnIndexes);
        return new SQLInterfacePreparedStatement(p);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement p = this.con.prepareStatement(sql, columnNames);
        return new SQLInterfacePreparedStatement(p);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.con.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.con.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.con.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.con.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.con.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.con.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.con.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.con.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.con.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.con.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.con.createStruct(typeName, attributes);
    }
}

