/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.cache;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.dyndns.nuda.mapper.SQLInterfaceBean;
import org.dyndns.nuda.mapper.cache.CacheManager;
import org.dyndns.nuda.mapper.cache.EmbedCacheManager;
import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;
import org.dyndns.nuda.plugin.PluginLoader;

public class CommonCacheManager
implements CacheManager {
    private static CacheManager cacheManager;
    private static CacheManager defaultCacheManager;
    private static CacheManager ME;

    static {
        defaultCacheManager = new EmbedCacheManager();
        ME = null;
    }

    public void init() {
    }

    public static CacheManager getInstance() {
        if (ME == null) {
            ME = new CommonCacheManager();
            PluginLoader loader = new PluginLoader();
            loader.loadPlugin(CacheManager.class);
        }
        return ME;
    }

    private CommonCacheManager() {
    }

    public static void setCacheManager(CacheManager cm) {
        cacheManager = cm;
    }

    @Override
    public PreparedStatement getStatement(String sql, SQLInterfaceConnection con, SQLInterfaceBean sqlInterfaceBean) throws SQLException {
        if (cacheManager == null) {
            return defaultCacheManager.getStatement(sql, con, sqlInterfaceBean);
        }
        return cacheManager.getStatement(sql, con, sqlInterfaceBean);
    }

    @Override
    public void deleteCache(String sql) {
        if (cacheManager != null) {
            defaultCacheManager.deleteCache(sql);
        } else {
            cacheManager.deleteCache(sql);
        }
    }
}

