/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dyndns.nuda.logger.CommonLogger;
import org.dyndns.nuda.logger.LoggerAdaptor;
import org.dyndns.nuda.mapper.DaoHelper;
import org.dyndns.nuda.mapper.QueryXMLBean;
import org.dyndns.nuda.mapper.QueryXMLReader;
import org.dyndns.nuda.mapper.SQLContainer;
import org.dyndns.nuda.mapper.SQLInterfaceBean;
import org.dyndns.nuda.mapper.SQLMapperException;
import org.dyndns.nuda.mapper.annotation.JDBCQuery;
import org.dyndns.nuda.mapper.cache.CacheManager;
import org.dyndns.nuda.mapper.cache.EmbedCacheManager;
import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;
import org.dyndns.nuda.mapper.event.SQLInterfaceEvent;
import org.dyndns.nuda.mapper.event.SQLInterfaceEventProcessor;
import org.dyndns.nuda.mapper.event.implementation.DeleteEvent;
import org.dyndns.nuda.mapper.event.implementation.InsertEvent;
import org.dyndns.nuda.mapper.event.implementation.RollBackEvent;
import org.dyndns.nuda.mapper.event.implementation.UpdateEvent;
import org.dyndns.nuda.mapper.helper.CommandDataPair;
import org.dyndns.nuda.mapper.helper.SQLInterfaceCommandInvocationHandler;
import org.dyndns.nuda.mapper.helper.command.AcceptCommand;
import org.dyndns.nuda.mapper.helper.xml.SQLInterfaceCommandResultBean;
import org.dyndns.nuda.mapper.helper.xml.SQLInterfaceCommandXMLBean;
import org.dyndns.nuda.mapper.helper.xml.SQLXMLInterfaceCommandScope;
import org.dyndns.nuda.mapper.paramchecker.AutoParameterChecker;
import org.dyndns.nuda.mapper.paramchecker.ParameterCheckResult;
import org.dyndns.nuda.mapper.parameter.AutoSQLParameter;
import org.dyndns.nuda.mapper.parser.AutoSQLParser;
import org.dyndns.nuda.mapper.reserver.Reserver;
import org.dyndns.nuda.mapper.sql.editor.AutoSQLEditorResolver;
import org.dyndns.nuda.mapper.sql.editor.SQLEditorResolver;
import org.dyndns.nuda.tools.util.ReflectUtil;
import org.dyndns.nuda.tools.util.StringUtil;
import org.dyndns.nuda.tools.xml.Context;
import org.dyndns.nuda.tools.xml.DefaultXMLReader;
import org.dyndns.nuda.tools.xml.ScopeHandler;

public class JDBCXMLInvocationHandler
implements InvocationHandler {
    private List<SQLInterfaceBean> queryBeans = new ArrayList<SQLInterfaceBean>();
    private SQLInterfaceConnection con = null;
    private boolean useAutoCommit = true;
    private boolean manualTransaction = false;
    public static final int FLAGS = 40;
    private static LoggerAdaptor logger = null;
    private Object ctrlCommandProxy = null;
    private AcceptCommand commandAcceptor = null;
    private static final String QST = "?";
    private static final String SPACE = " ";
    private static final String BLANK = "";
    private static final String p1StrSub = "(like|=|>|<|<=|>=)\\s+?(\\S+?\\s*?/\\*.+?\\*/)";
    private static final String p2Str = "(\\S+?\\s*/\\*\\s*?(.+?)\\s*?\\*/)";
    private static final String p1InsStr = "((\\d+|'.*?')\\s*?(/\\*.+?\\*/))";
    private static final Pattern P1INS;
    private static final String p2InsStr = "((\\S+?\\s*|'.+')\\s*?/\\*\\s*?(.+?)\\s*?\\*/)";
    private static final Pattern P2INS;
    private static final Pattern P1;
    private static final Pattern P2;
    private static final String METHOD_NAME_TO_STRING = "toString";
    private CacheManager cacheManager = null;
    private SQLEditorResolver sqlEditorResolver = AutoSQLEditorResolver.getInstance();
    private boolean isReserved = false;
    private Reserver currentReserver = null;

    static {
        logger = CommonLogger.getLoggerAdaptor();
        logger = logger.getLogger("JDBC-Container");
        P1INS = Pattern.compile(p1InsStr, 40);
        P2INS = Pattern.compile(p2InsStr, 40);
        P1 = Pattern.compile(p1StrSub);
        P2 = Pattern.compile(p2Str, 40);
    }

    public void setConnection(SQLInterfaceConnection con) {
        logger.info("{}({}):{}", new Object[]{"setConnection", "SQLInterfaceConnection", con});
        this.con = con;
    }

    public boolean isUseAutoCommit() {
        logger.info("{}({}):{}", new Object[]{"isUseAutoCommit", "void", BLANK});
        return this.useAutoCommit;
    }

    public void setUseAutoCommit(boolean useAutoCommit) {
        logger.info("{}({}):{}", new Object[]{"setUseAutoCommit", "boolean", useAutoCommit});
        this.useAutoCommit = useAutoCommit;
    }

    public boolean isManualTransaction() {
        logger.info("{}({}):{}", new Object[]{"isManualTransaction", "void", BLANK});
        return this.manualTransaction;
    }

    public void setManualTransaction(boolean manualTransaction) {
        logger.info("{}({}):{}", new Object[]{"setManualTransaction", "boolean", manualTransaction});
        this.manualTransaction = manualTransaction;
    }

    public Connection getConnection() {
        logger.info("{}({}):{}", new Object[]{"getConnection", "void", BLANK});
        return this.con;
    }

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass) throws Exception {
        logger.info("{}({}, {}):{}, {}", new Object[]{"JDBCXMLInvocationHandler", "Connection", "Class<?>", con, handlerClass});
        this.initContainer(con, handlerClass, true, false);
    }

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass, boolean useAutoCommit) throws Exception {
        logger.info("{}({}, {}, {}):{}, {}, {}", new Object[]{"JDBCXMLInvocationHandler", "Connection", "Class<?>", "boolean", con, handlerClass, useAutoCommit});
        this.initContainer(con, handlerClass, useAutoCommit, false);
    }

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass, boolean useAutoCommit, boolean manualTransaction) throws Exception {
        logger.info("{}({}, {}, {}, {}):{}, {}, {}, {}", new Object[]{"JDBCXMLInvocationHandler", "Connection", "Class<?>", "boolean", "boolean", con, handlerClass, useAutoCommit, manualTransaction});
        this.initContainer(con, handlerClass, useAutoCommit, manualTransaction);
        this.initSQLIFCtrlCommand();
    }

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass, ClassLoader currentClassLoader, boolean useAutoCommit, boolean manualTransaction) throws Exception {
        logger.info("{}({}, {}, {}, {}, {}):{}, {}, {}, {}, {}", new Object[]{"JDBCXMLInvocationHandler", "Connection", "Class<?>", "ClassLoader", "boolean", "boolean", con, handlerClass, currentClassLoader, useAutoCommit, manualTransaction});
        this.initContainer(con, handlerClass, currentClassLoader, useAutoCommit, manualTransaction);
        this.initSQLIFCtrlCommand();
    }

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass, ClassLoader loader) throws Exception {
        logger.info("{}({}, {}, {}):{}, {}, {}", new Object[]{"JDBCXMLInvocationHandler", "Connection", "Class<?>", "ClassLoader", con, handlerClass, loader});
        if (con == null) {
            logger.error("JDBC-Connection is NULL", (Throwable)new SQLMapperException("JDBC-Connection is NULL"));
            throw new SQLMapperException("JDBC-Connection is NULL");
        }
        if (handlerClass == null) {
            logger.error("handler class is NULL", (Throwable)new SQLMapperException("handler class is NULL"));
            throw new SQLMapperException("handler class is NULL");
        }
        if (!handlerClass.isInterface()) {
            String format = "unsupported class [{}]. class is not a interface";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            SQLMapperException e = new SQLMapperException(message);
            logger.error(message, (Throwable)e);
            throw new SQLMapperException(message);
        }
        if (handlerClass.isAnnotationPresent(JDBCQuery.class)) {
            SQLInterfaceConnection sourceConnection;
            this.con = con instanceof SQLInterfaceConnection ? (sourceConnection = (SQLInterfaceConnection)con) : new SQLInterfaceConnection(con);
            this.manualTransaction = false;
            this.con.setUseManualTransaction(false);
            JDBCQuery query = handlerClass.getAnnotation(JDBCQuery.class);
            String xmlPath = query.sqlxml();
            QueryXMLReader reader = new QueryXMLReader();
            InputStream is = loader.getResourceAsStream(xmlPath);
            reader.read(is);
            List<QueryXMLBean> result = reader.getResult();
            is.close();
            for (QueryXMLBean xmlBean : result) {
                SQLInterfaceBean inBean = this.convertSQLFromXML(xmlBean.getType(), xmlBean.getSql());
                inBean.id = xmlBean.getId();
                inBean.type = xmlBean.getType();
                this.queryBeans.add(inBean);
            }
        } else {
            SQLInterfaceConnection sourceConnection;
            this.con = con instanceof SQLInterfaceConnection ? (sourceConnection = (SQLInterfaceConnection)con) : new SQLInterfaceConnection(con);
            this.manualTransaction = false;
            this.con.setUseManualTransaction(false);
            String className = handlerClass.getCanonicalName().replace(".", "/");
            String xmlPath = className = String.valueOf(className) + ".xml";
            QueryXMLReader reader = new QueryXMLReader();
            InputStream is = loader.getResourceAsStream(xmlPath);
            reader.read(is);
            List<QueryXMLBean> result = reader.getResult();
            is.close();
            for (QueryXMLBean xmlBean : result) {
                SQLInterfaceBean inBean = this.convertSQLFromXML(xmlBean.getType(), xmlBean.getSql());
                inBean.id = xmlBean.getId();
                inBean.type = xmlBean.getType();
                this.queryBeans.add(inBean);
            }
        }
    }

    private void initContainer(Connection con, Class<?> handlerClass, boolean useAutoCommit, boolean manualTransaction) throws Exception {
        logger.info("{}({}, {}, {}, {}):{}, {}, {}, {}", new Object[]{"initContainer", "Connection", "Class<?>", "boolean", "boolean", con, handlerClass, useAutoCommit, manualTransaction});
        if (con == null) {
            logger.error("JDBC-Connection is NULL", (Throwable)new SQLMapperException("JDBC-Connection is NULL"));
            throw new SQLMapperException("JDBC-Connection is NULL");
        }
        if (handlerClass == null) {
            logger.error("handler class is NULL", (Throwable)new SQLMapperException("handler class is NULL"));
            throw new SQLMapperException("handler class is NULL");
        }
        if (!handlerClass.isInterface()) {
            String format = "unsupported class [{}]. class is not a interface";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            SQLMapperException e = new SQLMapperException(message);
            logger.error(message, (Throwable)e);
            throw new SQLMapperException(message);
        }
        if (handlerClass.isAnnotationPresent(JDBCQuery.class)) {
            SQLInterfaceConnection sourceConnection;
            this.con = con instanceof SQLInterfaceConnection ? (sourceConnection = (SQLInterfaceConnection)con) : new SQLInterfaceConnection(con);
            this.con.setUseManualTransaction(manualTransaction);
            this.manualTransaction = manualTransaction;
            this.useAutoCommit = useAutoCommit;
            JDBCQuery query = handlerClass.getAnnotation(JDBCQuery.class);
            String xmlPath = query.sqlxml();
            QueryXMLReader reader = new QueryXMLReader();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlPath);
            reader.read(is);
            List<QueryXMLBean> result = reader.getResult();
            for (QueryXMLBean xmlBean : result) {
                SQLInterfaceBean inBean = this.convertSQLFromXML(xmlBean.getType(), xmlBean.getSql());
                inBean.id = xmlBean.getId();
                inBean.type = xmlBean.getType();
                this.queryBeans.add(inBean);
            }
        } else {
            SQLInterfaceConnection sourceConnection;
            this.con = con instanceof SQLInterfaceConnection ? (sourceConnection = (SQLInterfaceConnection)con) : new SQLInterfaceConnection(con);
            this.con.setUseManualTransaction(manualTransaction);
            this.manualTransaction = manualTransaction;
            this.useAutoCommit = useAutoCommit;
            String className = handlerClass.getCanonicalName().replace(".", "/");
            String xmlPath = className = String.valueOf(className) + ".xml";
            QueryXMLReader reader = new QueryXMLReader();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlPath);
            reader.read(is);
            List<QueryXMLBean> result = reader.getResult();
            for (QueryXMLBean xmlBean : result) {
                SQLInterfaceBean inBean = this.convertSQLFromXML(xmlBean.getType(), xmlBean.getSql());
                inBean.id = xmlBean.getId();
                inBean.type = xmlBean.getType();
                this.queryBeans.add(inBean);
            }
        }
    }

    private void initContainer(Connection con, Class<?> handlerClass, ClassLoader currentClassLoader, boolean useAutoCommit, boolean manualTransaction) throws Exception {
        logger.info("{}({}, {}, {}, {}, {}):{}, {}, {}, {}, {}", new Object[]{"initContainer", "Connection", "Class<?>", "ClassLoader", "boolean", "boolean", con, handlerClass, currentClassLoader, useAutoCommit, manualTransaction});
        if (con == null) {
            logger.error("JDBC-Connection is NULL", (Throwable)new SQLMapperException("JDBC-Connection is NULL"));
            throw new SQLMapperException("JDBC-Connection is NULL");
        }
        if (handlerClass == null) {
            logger.error("handler class is NULL", (Throwable)new SQLMapperException("handler class is NULL"));
            throw new SQLMapperException("handler class is NULL");
        }
        if (!handlerClass.isInterface()) {
            String format = "unsupported class[{}]. class is not a interface";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            SQLMapperException e = new SQLMapperException(message);
            logger.error(message, (Throwable)e);
            throw new SQLMapperException(message);
        }
        if (handlerClass.isAnnotationPresent(JDBCQuery.class)) {
            SQLInterfaceConnection sourceConnection;
            this.con = con instanceof SQLInterfaceConnection ? (sourceConnection = (SQLInterfaceConnection)con) : new SQLInterfaceConnection(con);
            this.con.setUseManualTransaction(manualTransaction);
            this.manualTransaction = manualTransaction;
            this.useAutoCommit = useAutoCommit;
            JDBCQuery query = handlerClass.getAnnotation(JDBCQuery.class);
            String xmlPath = query.sqlxml();
            QueryXMLReader reader = new QueryXMLReader();
            InputStream is = null;
            is = currentClassLoader == null ? Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlPath) : currentClassLoader.getResourceAsStream(xmlPath);
            reader.read(is);
            List<QueryXMLBean> result = reader.getResult();
            for (QueryXMLBean xmlBean : result) {
                SQLInterfaceBean inBean = this.convertSQLFromXML(xmlBean.getType(), xmlBean.getSql());
                inBean.id = xmlBean.getId();
                inBean.type = xmlBean.getType();
                this.queryBeans.add(inBean);
            }
        } else {
            SQLInterfaceConnection sourceConnection;
            this.con = con instanceof SQLInterfaceConnection ? (sourceConnection = (SQLInterfaceConnection)con) : new SQLInterfaceConnection(con);
            this.con.setUseManualTransaction(manualTransaction);
            this.manualTransaction = manualTransaction;
            this.useAutoCommit = useAutoCommit;
            String className = handlerClass.getCanonicalName().replace(".", "/");
            String xmlPath = className = String.valueOf(className) + ".xml";
            QueryXMLReader reader = new QueryXMLReader();
            InputStream is = null;
            is = currentClassLoader == null ? Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlPath) : currentClassLoader.getResourceAsStream(xmlPath);
            reader.read(is);
            List<QueryXMLBean> result = reader.getResult();
            for (QueryXMLBean xmlBean : result) {
                SQLInterfaceBean inBean = this.convertSQLFromXML(xmlBean.getType(), xmlBean.getSql());
                inBean.id = xmlBean.getId();
                inBean.type = xmlBean.getType();
                this.queryBeans.add(inBean);
            }
        }
    }

    private void initSQLIFCtrlCommand() {
        Object proxy;
        logger.info("{}({}):{}", new Object[]{"initSQLIFCtrlCommand", "void", BLANK});
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        SQLInterfaceCommandInvocationHandler h = new SQLInterfaceCommandInvocationHandler(this);
        ArrayList commandList = new ArrayList();
        Context ctx = new Context();
        ctx.setValue((Object)new SQLInterfaceCommandResultBean());
        DefaultXMLReader reader = new DefaultXMLReader((ScopeHandler)SQLXMLInterfaceCommandScope.SQLInterfaceCommand, ctx);
        reader.read("interface-command.xml");
        SQLInterfaceCommandResultBean resultBean = (SQLInterfaceCommandResultBean)reader.getResult();
        for (SQLInterfaceCommandXMLBean xmlBean : resultBean.beans) {
            try {
                Class<?> intf = Class.forName(xmlBean.type);
                commandList.add(intf);
            }
            catch (ClassNotFoundException e) {
                throw new SQLMapperException(e);
            }
        }
        commandList.add(AcceptCommand.class);
        this.ctrlCommandProxy = proxy = Proxy.newProxyInstance(l, commandList.toArray(new Class[commandList.size()]), (InvocationHandler)h);
        this.commandAcceptor = (AcceptCommand)proxy;
    }

    private SQLInterfaceBean convertSQLFromXML(String queryType, String queryStr) {
        logger.info("{}({}, {}):{}, {}", new Object[]{"convertSQLFromXML", "String", "String", queryType, queryStr});
        SQLInterfaceBean bean = new SQLInterfaceBean();
        if ("SELECT".equals(queryType)) {
            String source = queryStr;
            Matcher m = P1.matcher(source);
            String result0 = BLANK;
            HashMap<Integer, String> matchMap = new HashMap<Integer, String>();
            int matchIndex = 0;
            while (m.find()) {
                int startRegion = m.regionStart();
                int endRegion = m.regionEnd();
                Matcher subMatcher = m.region(startRegion, endRegion);
                subMatcher.usePattern(P2);
                while (subMatcher.find()) {
                    String result2;
                    String matchResult = subMatcher.group(2);
                    matchMap.put(matchIndex + 1, matchResult.replace(SPACE, BLANK));
                    result0 = result2 = subMatcher.replaceFirst(QST);
                    subMatcher.reset(result2);
                    ++matchIndex;
                }
            }
            if (result0.isEmpty()) {
                result0 = queryStr;
            }
            bean.sqlStr = result0;
            bean.map = matchMap;
        } else if ("INSERT".equals(queryType) || "UPDATE".equals(queryType) || "DELETE".equals(queryType)) {
            String source = queryStr;
            Matcher m = P1INS.matcher(source);
            String result0 = BLANK;
            HashMap<Integer, String> matchMap = new HashMap<Integer, String>();
            int matchIndex = 0;
            while (m.find()) {
                int startRegion = m.regionStart();
                int endRegion = m.regionEnd();
                Matcher subMatcher = m.region(startRegion, endRegion);
                subMatcher.usePattern(P2INS);
                while (subMatcher.find()) {
                    String result2;
                    String matchResult = subMatcher.group(3);
                    matchMap.put(matchIndex + 1, matchResult.replace(SPACE, BLANK));
                    result0 = result2 = subMatcher.replaceFirst(QST);
                    subMatcher.reset(result2);
                    ++matchIndex;
                }
            }
            if (result0.isEmpty()) {
                result0 = queryStr;
            }
            bean.sqlStr = result0;
            bean.map = matchMap;
        } else {
            bean.sqlStr = queryStr;
            bean.map = null;
        }
        return bean;
    }

    private void initStatement(SQLInterfaceBean inBean, PreparedStatement pstmt, Object parameter) throws Exception {
        block5: {
            logger.info("{}({}, {}, {}):{}, {}, {}", new Object[]{"initStatement", "SQLInterfaceBean", "PreparedStatment", "Object", inBean, pstmt, parameter});
            try {
                if (inBean.map == null) break block5;
                for (Map.Entry<Integer, String> entry : inBean.map.entrySet()) {
                    int index = entry.getKey();
                    String propName = entry.getValue();
                    if (parameter == null) continue;
                    Object param01 = parameter;
                    String realMethodName = ReflectUtil.PREFIX.GETTER.camelCaseTo(propName);
                    Method getterMethod = null;
                    try {
                        getterMethod = param01.getClass().getDeclaredMethod(realMethodName, new Class[0]);
                    }
                    catch (Exception e) {
                        throw new SQLMapperException(e);
                    }
                    Class<?> paramType = getterMethod.getReturnType();
                    Object paramValue = getterMethod.invoke(param01, new Object[0]);
                    AutoSQLParameter.getInstance().setParameter(pstmt, index, paramValue, paramType);
                }
            }
            catch (Exception e) {
                logger.error(BLANK, (Throwable)e);
            }
        }
    }

    public boolean isReserved() {
        return this.isReserved;
    }

    public void setReserved(boolean isReserved) {
        this.isReserved = isReserved;
    }

    public void setReserver(Reserver reserver) {
        this.currentReserver = reserver;
    }

    public Reserver getReserver() {
        return this.currentReserver;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        block57: {
            logger.info("{}({}, {}, {}):{}, {}, {}", new Object[]{"invoke", "Object", "Method", "Object", "SQLInterface<X>", method.getName(), "argument<X>"});
            long remainingTime = System.currentTimeMillis();
            if (this.cacheManager == null) {
                this.cacheManager = new EmbedCacheManager();
            }
            String methodName = method.getName();
            Class<?>[] toStringMethodParamTypes = method.getParameterTypes();
            Class<?> toStringMethodReturnType = method.getReturnType();
            if ((toStringMethodParamTypes.length == 0 || String.class.equals(toStringMethodReturnType)) && methodName.equals(METHOD_NAME_TO_STRING)) {
                String result = this.queryBeans.toString();
                return result;
            }
            if (this.commandAcceptor.accept(method)) {
                Class<?> proxyCls = this.ctrlCommandProxy.getClass();
                Method cmdMethod = proxyCls.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return cmdMethod.invoke(this.ctrlCommandProxy, args);
            }
            SQLInterfaceBean inBean = null;
            SQLContainer sqlContainer = null;
            AutoSQLParser parser = new AutoSQLParser();
            for (SQLInterfaceBean aBean : this.queryBeans) {
                if (!methodName.equals(aBean.id)) continue;
                inBean = aBean;
                sqlContainer = parser.parse(aBean.id, aBean.type, aBean.sqlStr);
                break;
            }
            if (inBean == null) {
                String message0 = StringUtil.format((String)"\u539f\u56e0:\u30e1\u30bd\u30c3\u30c9\u540d:{} \u306b\u5bfe\u5fdc\u3059\u308bSQL\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u30e1\u30bd\u30c3\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3067\u3057\u305f", (Object[])new Object[]{methodName});
                String message = StringUtil.format((String)"QueryInterface\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f<{}>", (Object[])new Object[]{message0});
                throw new SQLMapperException(message);
            }
            ParameterCheckResult paramCheckResult = AutoParameterChecker.getInstance().checkParameter(method, args);
            if (!paramCheckResult.isValid()) {
                String message0 = BLANK;
                message0 = paramCheckResult.getErrorMessage() != null ? (paramCheckResult.getCause() != null ? StringUtil.format((String)"\u539f\u56e0:\u30e1\u30bd\u30c3\u30c9\u540d{}:{} ({}):\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u30c1\u30a7\u30c3\u30af\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Object[])new Object[]{methodName, paramCheckResult.getErrorMessage(), paramCheckResult.getCause().getMessage()}) : StringUtil.format((String)"\u539f\u56e0:\u30e1\u30bd\u30c3\u30c9\u540d{}:{}:\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u30c1\u30a7\u30c3\u30af\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Object[])new Object[]{methodName, paramCheckResult.getErrorMessage()})) : StringUtil.format((String)"\u539f\u56e0:\u30e1\u30bd\u30c3\u30c9\u540d:{}:\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u30c1\u30a7\u30c3\u30af\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Object[])new Object[]{methodName});
                String message = StringUtil.format((String)"SQL\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u4e0d\u6b63\u3067\u3059<{}>", (Object[])new Object[]{message0});
                throw new SQLMapperException(message);
            }
            String conditionedSQL = BLANK;
            if (this.sqlEditorResolver.accept(args, inBean.sqlStr)) {
                conditionedSQL = this.sqlEditorResolver.editSql(args, inBean.sqlStr);
            }
            PreparedStatement pstmt = this.cacheManager.getStatement(conditionedSQL, this.con, inBean);
            pstmt.clearParameters();
            if ("SELECT".equals(inBean.type)) {
                if (inBean.map != null) {
                    try {
                        if (args != null && args.length != 0 && args[0] != null) {
                            this.initStatement(inBean, pstmt, args[0]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ArrayList result0 = null;
                Class<?> cls = method.getReturnType();
                Class returnType = null;
                if (cls.equals(List.class)) {
                    ParameterizedType paramType = (ParameterizedType)method.getGenericReturnType();
                    Type[] typeArray = paramType.getActualTypeArguments();
                    returnType = (Class)typeArray[0];
                    if (returnType == null) {
                        throw new SQLMapperException("query SELECT unknown return type");
                    }
                    ArrayList result = new ArrayList();
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Object obj = DaoHelper.convertResult(rs, returnType);
                        result.add(obj);
                    }
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    result0 = result;
                } else {
                    void var19_41;
                    ResultSet rs = pstmt.executeQuery();
                    Object var19_38 = null;
                    Class cls0 = null;
                    cls0 = cls == Integer.TYPE ? Integer.class : (cls == Long.TYPE ? Long.class : (cls == Double.TYPE ? Double.class : (cls == Boolean.TYPE ? Boolean.class : cls)));
                    if (rs.next()) {
                        Integer n = DaoHelper.convertResult(rs, cls0);
                    } else {
                        List<Object> result = Arrays.asList(cls0.newInstance());
                        result.clear();
                        List<Object> list = result;
                    }
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    result0 = var19_41;
                }
                return result0;
            }
            if ("INSERT".equals(inBean.type) || "UPDATE".equals(inBean.type) || "DELETE".equals(inBean.type)) {
                pstmt.clearParameters();
                Class<?>[] paramTypes = method.getParameterTypes();
                ArrayList<Object> operatedList = new ArrayList<Object>();
                if (paramTypes.length > 0) {
                    Class<?> paramType = paramTypes[0];
                    if (List.class.equals(paramType)) {
                        Object param = args[0];
                        List list = (List)param;
                        for (Object o : list) {
                            if (inBean.map == null) continue;
                            this.initStatement(inBean, pstmt, o);
                            pstmt.addBatch();
                            pstmt.clearParameters();
                            operatedList.add(o);
                        }
                    } else if (paramType.isArray()) {
                        void var19_44;
                        int length = Array.getLength(args[0]);
                        boolean bl = false;
                        while (var19_44 < length) {
                            Object o;
                            o = Array.get(args[0], (int)var19_44);
                            if (inBean.map != null) {
                                this.initStatement(inBean, pstmt, o);
                                pstmt.addBatch();
                                pstmt.clearParameters();
                                operatedList.add(o);
                            }
                            ++var19_44;
                        }
                    } else if (inBean.map != null) {
                        this.initStatement(inBean, pstmt, args[0]);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                        operatedList.add(args[0]);
                    }
                } else {
                    pstmt.addBatch();
                }
                try {
                    Class<?> methodReturnType;
                    if (!this.manualTransaction) {
                        this.con.setAutoCommit(this.useAutoCommit);
                    }
                    int[] results = pstmt.executeBatch();
                    if (!this.manualTransaction) {
                        if (!this.useAutoCommit) {
                            SQLInterfaceEvent event = null;
                            remainingTime = System.currentTimeMillis() - remainingTime;
                            if ("INSERT".equals(inBean.type)) {
                                InsertEvent insertEvent = new InsertEvent();
                                insertEvent.setInsertedObjects(operatedList);
                                insertEvent.setInterfaceBean(inBean);
                                insertEvent.setRemainingTime(remainingTime);
                                event = insertEvent;
                            } else if ("UPDATE".equals(inBean.type)) {
                                UpdateEvent updateEvent = new UpdateEvent();
                                updateEvent.setUpdatedObjects(operatedList);
                                updateEvent.setInterfaceBean(inBean);
                                updateEvent.setRemainingTime(remainingTime);
                                event = updateEvent;
                            } else if ("DELETE".equals(inBean.type)) {
                                DeleteEvent deleteEvent = new DeleteEvent();
                                deleteEvent.setDeletedObjects(operatedList);
                                deleteEvent.setInterfaceBean(inBean);
                                deleteEvent.setRemainingTime(remainingTime);
                                event = deleteEvent;
                            }
                            this.con.commitWith(event);
                        }
                    } else {
                        CommandDataPair pair = new CommandDataPair();
                        pair.setSqlInterfaceBean(inBean);
                        for (Object e : operatedList) {
                            pair.addData(e);
                        }
                        this.con.addCommand(pair);
                    }
                    if ((methodReturnType = method.getReturnType()).getComponentType() != null && methodReturnType.getComponentType().equals(Integer.TYPE)) {
                        return results;
                    }
                    break block57;
                }
                catch (SQLException e) {
                    if (!this.manualTransaction) {
                        if (!this.useAutoCommit) {
                            this.con.rollback();
                            RollBackEvent event = new RollBackEvent();
                            event.setCause(e);
                            event.setInterfaceBean(inBean);
                            SQLInterfaceEventProcessor.newInstance().broadcast(event);
                        }
                        throw new SQLMapperException(e);
                    }
                    throw new SQLMapperException(e);
                }
            }
            if ("CREATE".equals(inBean.type)) {
                try {
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    throw new SQLMapperException(e);
                }
            }
            try {
                if (!this.manualTransaction) {
                    this.con.setAutoCommit(this.useAutoCommit);
                }
                pstmt.execute();
                if (!this.manualTransaction && !this.useAutoCommit) {
                    this.con.commit();
                }
            }
            catch (SQLException e) {
                if (!this.manualTransaction) {
                    if (!this.useAutoCommit) {
                        this.con.rollback();
                        RollBackEvent event = new RollBackEvent();
                        event.setCause(e);
                        SQLInterfaceEventProcessor.newInstance().broadcast(event);
                    }
                    throw new SQLMapperException(e);
                }
                throw new SQLMapperException(e);
            }
        }
        return null;
    }
}

