/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.sql.editor;

import java.util.ArrayList;
import java.util.List;
import org.dyndns.nuda.mapper.sql.editor.ConditionedSQLEditorResolver;
import org.dyndns.nuda.mapper.sql.editor.NOPSQLEditorResolver;
import org.dyndns.nuda.mapper.sql.editor.SQLEditorResolver;
import org.dyndns.nuda.plugin.PluginLoader;

public class AutoSQLEditorResolver
implements SQLEditorResolver {
    private static List<SQLEditorResolver> resolvers = new ArrayList<SQLEditorResolver>();
    private static SQLEditorResolver ME = null;

    private AutoSQLEditorResolver() {
        resolvers.add(new ConditionedSQLEditorResolver());
        resolvers.add(new NOPSQLEditorResolver());
    }

    public static void addResolver(SQLEditorResolver resolver) {
        if (resolver != null) {
            resolvers.add(resolver);
        }
    }

    private List<SQLEditorResolver> getResolvers() {
        return resolvers;
    }

    public static SQLEditorResolver getInstance() {
        if (ME == null) {
            ME = new AutoSQLEditorResolver();
            PluginLoader loader = new PluginLoader();
            loader.loadPlugin(SQLEditorResolver.class);
        }
        return ME;
    }

    @Override
    public boolean accept(Object[] args, String sql) {
        for (SQLEditorResolver resolver : resolvers) {
            if (!resolver.accept(args, sql)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String editSql(Object[] args, String sql) {
        String tmpSQL = sql;
        for (SQLEditorResolver resolver : this.getResolvers()) {
            if (!resolver.accept(args, sql)) continue;
            tmpSQL = resolver.editSql(args, tmpSQL);
        }
        return tmpSQL;
    }

    public void init() {
    }
}

