/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dyndns.nuda.mapper.SQLContainer;
import org.dyndns.nuda.mapper.SQLContainerImpl;
import org.dyndns.nuda.mapper.parser.AutoSQLParser;
import org.dyndns.nuda.mapper.parser.QUERY_TYPE;
import org.dyndns.nuda.mapper.parser.SQLParser;

public class SelectSQLParser
implements SQLParser {
    private static final int FLAGS = 40;
    private static final String p1StrSub = "(like|=|>|<|<=|>=)\\s+?(\\S+?\\s*?/\\*.+?\\*/)";
    private static final String p2Str = "(\\S+?\\s*/\\*\\s*?(.+?)\\s*?\\*/)";
    private static final Pattern P1 = Pattern.compile("(like|=|>|<|<=|>=)\\s+?(\\S+?\\s*?/\\*.+?\\*/)");
    private static final Pattern P2 = Pattern.compile("(\\S+?\\s*/\\*\\s*?(.+?)\\s*?\\*/)", 40);
    private static final String QST = "?";
    private static final String SPACE = " ";
    private static final String BLANK = "";
    private static final String selectStatementPatternStr = "\\s*(select|SELECT)\\s+?(\\s*?\\S+?\\s*?)+";
    private static final Pattern selectStatementPattern = Pattern.compile("\\s*(select|SELECT)\\s+?(\\s*?\\S+?\\s*?)+", 42);

    @Override
    public SQLContainer parse(String queryId, String queryType, String sql) {
        System.out.println("SelectSQLParser");
        String source = sql;
        Matcher m = P1.matcher(source);
        String result0 = BLANK;
        HashMap<Integer, String> matchMap = new HashMap<Integer, String>();
        HashMap<String, Integer> matchReverseMap = new HashMap<String, Integer>();
        int matchIndex = 0;
        while (m.find()) {
            int startRegion = m.regionStart();
            int endRegion = m.regionEnd();
            Matcher subMatcher = m.region(startRegion, endRegion);
            subMatcher.usePattern(P2);
            while (subMatcher.find()) {
                String result2;
                String matchResult = subMatcher.group(2);
                matchMap.put(matchIndex + 1, matchResult.replace(SPACE, BLANK));
                matchReverseMap.put(matchResult.replace(SPACE, BLANK), matchIndex + 1);
                result0 = result2 = subMatcher.replaceFirst(QST);
                subMatcher.reset(result2);
                ++matchIndex;
            }
        }
        if (result0.isEmpty()) {
            result0 = sql;
        }
        SQLContainerImpl c = new SQLContainerImpl(queryId, QUERY_TYPE.valueOf(queryType), result0);
        for (Map.Entry entry : matchMap.entrySet()) {
            c.put((Integer)entry.getKey(), (String)entry.getValue());
        }
        return c;
    }

    @Override
    public boolean accept(String queryType, String sql) {
        if (this.checkParameter(queryType, sql)) {
            return false;
        }
        boolean result = this.checkStatement(sql);
        return result;
    }

    private boolean checkParameter(String queryType, String sql) {
        boolean checkQueryType = queryType == null || queryType.isEmpty();
        boolean checkSql = sql == null || sql.isEmpty();
        return !checkQueryType && !checkSql;
    }

    private boolean checkStatement(String sql) {
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        Matcher matcher = selectStatementPattern.matcher(sql);
        return matcher.matches();
    }

    public void init() {
        AutoSQLParser.addParser(this);
    }
}

