/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.parameter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dyndns.nuda.mapper.parameter.BigDecimalSQLParameter;
import org.dyndns.nuda.mapper.parameter.BigIntegerSQLParameter;
import org.dyndns.nuda.mapper.parameter.BooleanSQLParameter;
import org.dyndns.nuda.mapper.parameter.DoubleSQLParameter;
import org.dyndns.nuda.mapper.parameter.IntSQLParameter;
import org.dyndns.nuda.mapper.parameter.JavaSqlDateSQLParameter;
import org.dyndns.nuda.mapper.parameter.JavaUtilDateSQLParameter;
import org.dyndns.nuda.mapper.parameter.LongSQLParameter;
import org.dyndns.nuda.mapper.parameter.NOPSQLParameter;
import org.dyndns.nuda.mapper.parameter.SQLParameter;
import org.dyndns.nuda.mapper.parameter.StringSQLParameter;

public class AutoSQLParameter
implements SQLParameter {
    private static AutoSQLParameter ME = null;
    private static final Object LOCK = new Object();
    private List<SQLParameter> parameterList = new ArrayList<SQLParameter>();

    private AutoSQLParameter() {
        this.parameterList.add(new IntSQLParameter());
        this.parameterList.add(new StringSQLParameter());
        this.parameterList.add(new JavaUtilDateSQLParameter());
        this.parameterList.add(new JavaSqlDateSQLParameter());
        this.parameterList.add(new LongSQLParameter());
        this.parameterList.add(new DoubleSQLParameter());
        this.parameterList.add(new BigIntegerSQLParameter());
        this.parameterList.add(new BigDecimalSQLParameter());
        this.parameterList.add(new BooleanSQLParameter());
        this.parameterList.add(new NOPSQLParameter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutoSQLParameter getInstance() {
        if (ME == null) {
            Object object = LOCK;
            synchronized (object) {
                if (ME == null) {
                    ME = new AutoSQLParameter();
                }
            }
        }
        return ME;
    }

    @Override
    public boolean accept(Class<?> parameterType) {
        return true;
    }

    @Override
    public void setParameter(PreparedStatement pstmt, int index, Object parameter, Class<?> parameterType) throws SQLException {
        if (pstmt == null) {
            return;
        }
        for (SQLParameter p : this.parameterList) {
            if (!p.accept(parameterType)) continue;
            p.setParameter(pstmt, index, parameter, parameterType);
            break;
        }
    }
}

