/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dyndns.nuda.logger.CommonLogger;
import org.dyndns.nuda.mapper.ConnectionBean;
import org.dyndns.nuda.mapper.QueryXMLBean;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QueryXMLReader
extends DefaultHandler {
    private int currentScope = SCOPE_INVALID;
    private static int SCOPE_ROOT = 1;
    private static int SCOPE_STATEMENT = 2;
    private static int SCOPE_CONNECTION = 3;
    private static int SCOPE_CONNECTION_PARAM = 4;
    private static int SCOPE_INVALID = -1;
    private static final String QNAME_REPSERV_TASK = "statements";
    private static final String QNAME_TASK_ELEMENT = "statement";
    private static final String QNAME_CONNECTION = "connection";
    private static final String QNAME_CONNECTION_PARAM = "param";
    private List<QueryXMLBean> resultList = new ArrayList<QueryXMLBean>();
    private QueryXMLBean context = null;
    private ConnectionBean conBean = new ConnectionBean();

    public void changeScope(String qName) {
        this.currentScope = QNAME_REPSERV_TASK.equals(qName) ? SCOPE_ROOT : (QNAME_TASK_ELEMENT.equals(qName) ? SCOPE_STATEMENT : (QNAME_CONNECTION.equals(qName) ? SCOPE_CONNECTION : (QNAME_CONNECTION_PARAM.equals(qName) ? SCOPE_CONNECTION_PARAM : SCOPE_INVALID)));
    }

    public List<QueryXMLBean> getResult() {
        return this.resultList;
    }

    public ConnectionBean getConnectionInfo() {
        return this.conBean;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.changeScope(qName);
        if (this.currentScope == SCOPE_ROOT) {
            this.resultList = new ArrayList<QueryXMLBean>();
        } else if (this.currentScope == SCOPE_STATEMENT) {
            this.context = new QueryXMLBean();
            String id = attributes.getValue("id");
            String type = attributes.getValue("type");
            if (type == null || type.isEmpty()) {
                type = "OTHER";
            }
            this.context.setId(id);
            this.context.setType(type);
        } else if (this.currentScope == SCOPE_CONNECTION) {
            String url;
            this.conBean.url = url = attributes.getValue("url");
        } else if (this.currentScope == SCOPE_CONNECTION_PARAM) {
            String key = attributes.getValue("key");
            String value = attributes.getValue("value");
            this.conBean.prop.put(key, value);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.changeScope(qName);
        if (this.currentScope == SCOPE_STATEMENT) {
            this.resultList.add(this.context);
        }
        this.currentScope = SCOPE_INVALID;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentScope == SCOPE_STATEMENT) {
            String value = new String(ch, start, length);
            StringBuilder b = new StringBuilder();
            b.append(this.context.getSql()).append(value);
            this.context.setSql(b.toString());
        }
    }

    public void read(InputStream is) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser perser = factory.newSAXParser();
            try {
                perser.parse(is, (DefaultHandler)this);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("InputStream Is Null");
            }
        }
        catch (ParserConfigurationException e) {
            assert (false);
        }
        catch (SAXException e) {
            CommonLogger.getLoggerAdaptor().getLogger("QueryXMLReader").error("error(input:InputStream)", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            CommonLogger.getLoggerAdaptor().getLogger("QueryXMLReader").error("error", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public void read(File file) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser perser = factory.newSAXParser();
            perser.parse(file, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            assert (false);
        }
        catch (SAXException e) {
            CommonLogger.getLoggerAdaptor().getLogger("QueryXMLReader").error("error(input:file)", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            CommonLogger.getLoggerAdaptor().getLogger("QueryXMLReader").error("error", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }
}

