/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.dyndns.nuda.mapper.SQLMapperException;

public class DaoHelper {
    private static final String SETTER_PREFIX = "set";

    private DaoHelper() {
    }

    public static <D> D convertResult(ResultSet resultSet, Class<D> cls) {
        try {
            if (cls == Integer.class || cls == Integer.TYPE) {
                Integer result = resultSet.getInt(1);
                if (cls.isPrimitive()) {
                    return (D)result;
                }
                D result0 = cls.cast(result);
                return result0;
            }
            if (cls == String.class) {
                String result = resultSet.getString(1);
                D result0 = cls.cast(result);
                return result0;
            }
            if (cls == Date.class) {
                java.sql.Date result = resultSet.getDate(1);
                D result0 = cls.cast(new Date(result.getTime()));
                return result0;
            }
            if (cls == java.sql.Date.class) {
                java.sql.Date result = resultSet.getDate(1);
                D result0 = cls.cast(result);
                return result0;
            }
            if (cls == Long.class || cls == Long.TYPE) {
                Long result = resultSet.getLong(1);
                if (cls.isPrimitive()) {
                    return (D)result;
                }
                D result0 = cls.cast(result);
                return result0;
            }
            if (cls == Double.class || cls == Double.TYPE) {
                Double result = resultSet.getDouble(1);
                if (cls.isPrimitive()) {
                    return (D)result;
                }
                D result0 = cls.cast(result);
                return result0;
            }
            if (cls == BigInteger.class) {
                throw new SQLException("\u30bf\u30a4\u30d7:BigInteger\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u304a\u308a\u307e\u305b\u3093");
            }
            if (cls == BigDecimal.class) {
                BigDecimal result = resultSet.getBigDecimal(1);
                D result0 = cls.cast(result);
                return result0;
            }
            if (cls == Boolean.class || cls == Boolean.TYPE) {
                Boolean result = resultSet.getBoolean(1);
                if (cls.isPrimitive()) {
                    return (D)result;
                }
                D result0 = cls.cast(result);
                return result0;
            }
            ResultSetMetaData metadata = resultSet.getMetaData();
            ArrayList<String> columnList = new ArrayList<String>();
            int i = 1;
            while (i <= metadata.getColumnCount()) {
                String columnLabel = metadata.getColumnLabel(i);
                columnLabel = columnLabel.toLowerCase();
                columnList.add(columnLabel);
                ++i;
            }
            Method[] methods = cls.getDeclaredMethods();
            D beans = cls.newInstance();
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method aMethod = methodArray[n2];
                String methodName = aMethod.getName();
                if (methodName.startsWith(SETTER_PREFIX)) {
                    Class<?>[] paramClasses;
                    String operateParamName = methodName.substring(3, methodName.length());
                    String startChar = operateParamName.substring(0, 1);
                    startChar = startChar.toLowerCase();
                    operateParamName = operateParamName.substring(1, operateParamName.length());
                    String realName = String.valueOf(startChar) + operateParamName;
                    int matchCount = 0;
                    for (String aColumn : columnList) {
                        if (!realName.toLowerCase().equals(aColumn)) continue;
                        ++matchCount;
                        break;
                    }
                    if (matchCount == 0) {
                        for (String aColumn : columnList) {
                            if (!realName.toUpperCase().equals(aColumn)) continue;
                            realName = realName.toUpperCase();
                            ++matchCount;
                            break;
                        }
                    }
                    if (matchCount != 0 && (aMethod.isAccessible() || aMethod.getModifiers() == 1) && (paramClasses = aMethod.getParameterTypes()) != null && paramClasses.length == 1) {
                        java.sql.Date d;
                        Class<?> targetClass = paramClasses[0];
                        if (targetClass == Integer.TYPE) {
                            aMethod.invoke(beans, resultSet.getInt(realName));
                        } else if (targetClass == String.class) {
                            aMethod.invoke(beans, resultSet.getString(realName));
                        } else if (targetClass == Date.class) {
                            d = resultSet.getDate(realName);
                            aMethod.invoke(beans, new Date(d.getTime()));
                        } else if (targetClass == java.sql.Date.class) {
                            d = resultSet.getDate(realName);
                            aMethod.invoke(beans, d);
                        } else if (targetClass == Long.TYPE) {
                            aMethod.invoke(beans, resultSet.getLong(realName));
                        } else if (targetClass == Double.TYPE) {
                            aMethod.invoke(beans, resultSet.getDouble(realName));
                        } else {
                            if (targetClass == BigInteger.class) {
                                throw new SQLException("\u30bf\u30a4\u30d7:BigInteger\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u304a\u308a\u307e\u305b\u3093");
                            }
                            if (targetClass == BigDecimal.class) {
                                aMethod.invoke(beans, resultSet.getBigDecimal(realName));
                            } else if (targetClass == Boolean.TYPE) {
                                aMethod.invoke(beans, resultSet.getBoolean(realName));
                            }
                        }
                    }
                }
                ++n2;
            }
            return beans;
        }
        catch (InstantiationException e) {
            throw new SQLMapperException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLMapperException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SQLMapperException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw new SQLMapperException(cause);
        }
        catch (SQLException e) {
            throw new SQLMapperException(e);
        }
    }
}

