package org.dyndns.nuda.mapper.helper.command;

import org.dyndns.nuda.mapper.helper.SQLInterfaceControllerCommand;

/**
 * ユーザベーストランザクション制御機能を操作するためのSQLインタフェースコンテナ制御コマンドです
 * 
 * @author nkoseki
 * 
 */
public interface UseManualTransactionCommand extends
		SQLInterfaceControllerCommand {
	
	/**
	 * ユーザベーストランザクション機能を制御します
	 * 
	 * @param useManualTransaction
	 *            ユーザベーストランザクション機能ON:true / ユーザベーストランザクション機能OFF:false
	 */
	public void useManualTransaction(boolean useManualTransaction);
	
	/**
	 * 現在設定されているユーザベーストランザクション機能の状態を取得します
	 * 
	 * @return useManualTransaction ユーザベーストランザクション機能ON:true / ユーザベーストランザクション機能OFF:false
	 */
	public boolean isUseManualTransaction();
}
