package org.dyndns.nuda.mapper.helper.command;

import java.sql.SQLException;

import org.dyndns.nuda.mapper.JDBCXMLInvocationHandler;

/**
 * SQLインタフェースコンテナ制御コマンド：トランザクション制御コマンド
 * 
 * @author nkoseki
 * 
 */
public class TransactionCommandImpl implements TransactionCommand {
	private JDBCXMLInvocationHandler	container;
	
	@Override
	public void setContainer(final JDBCXMLInvocationHandler container) {
		this.container = container;
	}
	
	@Override
	public JDBCXMLInvocationHandler getContainer() {
		return this.container;
	}
	
	@Override
	public void commit() throws SQLException {
		if (this.container != null) {
			this.container.getConnection().commit();
		}
	}
	
	@Override
	public void rollback() throws SQLException {
		if (this.container != null) {
			this.container.getConnection().rollback();
		}
	}
	
}
