package org.dyndns.nuda.mapper.helper;

import org.dyndns.nuda.mapper.JDBCXMLInvocationHandler;

/**
 * SQLInterfaceコンテナを制御するためのコマンドを表すインタフェースです
 * 
 * @author nkoseki
 * 
 */
public interface SQLInterfaceControllerCommand {
	
	/**
	 * このインスタンスにSQLInterfaceコンテナを設定します
	 * 
	 * @param container
	 *            SQLInterfaceコンテナ
	 */
	public void setContainer(JDBCXMLInvocationHandler container);
	
	/**
	 * このインスタンスに設定されているSQLInterfaceコンテナを取得します
	 * 
	 * @return SQLInterfaceコンテナ
	 */
	public JDBCXMLInvocationHandler getContainer();
}
