package org.dyndns.nuda.mapper.helper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dyndns.nuda.mapper.JDBCXMLInvocationHandler;
import org.dyndns.nuda.mapper.helper.command.AcceptCommand;
import org.dyndns.nuda.mapper.helper.xml.SQLInterfaceCommandResultBean;
import org.dyndns.nuda.mapper.helper.xml.SQLInterfaceCommandXMLBean;
import org.dyndns.nuda.mapper.helper.xml.SQLXMLInterfaceCommandScope;
import org.dyndns.nuda.tools.xml.Context;
import org.dyndns.nuda.tools.xml.DefaultXMLReader;

/**
 * SQLインタフェース操作コマンドを受け付けるためのプロキシ用ハンドラクラスです
 * 
 * @author nkoseki
 * 
 */
public class SQLInterfaceCommandInvocationHandler implements
		SQLInterfaceControllerCommand, AcceptCommand, InvocationHandler {
	private JDBCXMLInvocationHandler	container;
	
	/*
	 * インタフェースと実装クラスのペアを管理します
	 */
	private Map<Class<?>, Class<?>>		implementationMap		=
																	new HashMap<Class<?>, Class<?>>();
	
	/*
	 * インタフェースと実装クラスインスタンスのペアを管理します
	 */
	private Map<Class<?>, Object>		implInstanceMap			=
																	new HashMap<Class<?>, Object>();
	
	private CommandSigniture			acceptCommandSigniture	= null;
	
	private List<CommandAcceptor>		acceptors				= null;
	
	/**
	 * 引数にSQLインタフェースコンテナを指定してインスタンスを生成します
	 * 
	 * @param container
	 *            SQLインタフェースコンテナ
	 */
	public SQLInterfaceCommandInvocationHandler(
			final JDBCXMLInvocationHandler container) {
		this.container = container;
		this.initIH();
	}
	
	/**
	 * このインスタンスにSQLインタフェースコンテナを設定します
	 */
	@Override
	public void setContainer(final JDBCXMLInvocationHandler container) {
		this.container = container;
	}
	
	private void initIH() {
		try {
			//			System.out.println("SQLインタフェースコンテナ制御コマンド：accept 設定処理");
			Method acceptMethod =
				this.getClass().getDeclaredMethod(
					"accept",
					new Class[] { Method.class });
			this.acceptCommandSigniture = new CommandSigniture(acceptMethod);
		} catch (SecurityException e) {
			System.out.println("SQLインタフェースコンテナ制御コマンド：accept 設定処理：失敗["
				+ e.getMessage()
				+ "]");
		} catch (NoSuchMethodException e) {
			System.out.println("SQLインタフェースコンテナ制御コマンド：accept 設定処理：失敗["
				+ e.getMessage()
				+ "]");
		}
		
		// interface-command.xml読み込み処理
		Context<SQLInterfaceCommandResultBean> ctx =
			new Context<SQLInterfaceCommandResultBean>();
		
		ctx.setValue(new SQLInterfaceCommandResultBean());
		
		DefaultXMLReader<SQLInterfaceCommandResultBean> reader =
			new DefaultXMLReader<SQLInterfaceCommandResultBean>(
				SQLXMLInterfaceCommandScope.SQLInterfaceCommand,
				ctx);
		
		reader.read("interface-command.xml");
		
		SQLInterfaceCommandResultBean resultBean = reader.getResult();
		for (SQLInterfaceCommandXMLBean xmlBean : resultBean.beans) {
			try {
				Class<?> intf = Class.forName(xmlBean.type);
				Class<?> implementation = Class.forName(xmlBean.implementation);
				this.implementationMap.put(intf, implementation);
				//				System.out.println("type = ["
				//					+ intf.getCanonicalName()
				//					+ "], implementation = ["
				//					+ implementation.getCanonicalName()
				//					+ "] 登録完了");
			} catch (ClassNotFoundException e) {
				System.out.println("SQLインタフェースコンテナ制御コマンドクラスのロードに失敗："
					+ e.getMessage());
			}
		}
	}
	
	/**
	 * このインスタンスに設定済みのSQLインタフェースコンテナを取得します
	 */
	@Override
	public JDBCXMLInvocationHandler getContainer() {
		try {
			Method acceptMethod =
				this.getClass().getDeclaredMethod(
					"accept",
					new Class[] { Method.class });
			this.acceptCommandSigniture = new CommandSigniture(acceptMethod);
		} catch (SecurityException e) {
		} catch (NoSuchMethodException e) {
		}
		
		return this.container;
		
	}
	
	@Override
	public Object invoke(final Object proxy, final Method method,
			final Object[] args) throws Throwable {
		
		Class<?> proxyClass = proxy.getClass();
		
		// コマンドシグニチャの生成
		CommandSigniture currentCommandSigniture = new CommandSigniture(method);
		
		if (this.acceptors == null || this.acceptors.size() == 0) {
			// SQLInterfaceコマンドアクセプタの生成処理
			this.acceptors = new ArrayList<CommandAcceptor>();
			for (Class<?> c : proxyClass.getInterfaces()) {
				//				System.out.println(c.getCanonicalName() + " のアクセプタ生成");
				this.acceptors.add(CommandAcceptorHelper.getAcceptor(c));
				//				System.out.println(c.getCanonicalName() + " のアクセプタ生成完了");
			}
		}
		
		if (method.getName().equals("toString")) {
			return this.toString();
		} else if (this.acceptCommandSigniture.equals(currentCommandSigniture)) {
			
			if (args.length == 0 || args[0] == null) {
				return this.accept(null);
			} else {
				return this.accept((Method) args[0]);
			}
			
		} else {
			for (CommandAcceptor acceptor : this.acceptors) {
				if (acceptor.accept(method)) {
					Class<?> decClass = acceptor.getDeclaredClass();
					Class<?> implClass = this.implementationMap.get(decClass);
					if (implClass == null) {
						System.out.println("メソッド名：["
							+ method.getName()
							+ "] accept by ["
							+ decClass.getCanonicalName()
							+ "] 実装=[取得できませんでした]");
					} else {
						//						System.out.println("メソッド名：["
						//							+ method.getName()
						//							+ "] accept by ["
						//							+ decClass.getCanonicalName()
						//							+ "] 実装=["
						//							+ implClass.getCanonicalName()
						//							+ "]");
						
						try {
							Object implInstance = null;
							
							if (!this.implInstanceMap.containsKey(decClass)) {
								implInstance = implClass.newInstance();
								this.implInstanceMap
									.put(decClass, implInstance);
								
								if (implInstance instanceof SQLInterfaceControllerCommand) {
									SQLInterfaceControllerCommand c =
										(SQLInterfaceControllerCommand) implInstance;
									c.setContainer(this.container);
									//									System.out.println("コマンド実装["
									//										+ implInstance
									//											.getClass()
									//											.getCanonicalName()
									//										+ "]にSQLインタフェースコンテナを設定しました");
								}
							} else {
								implInstance =
									this.implInstanceMap.get(decClass);
							}
							
							if (implInstance != null) {
								return method.invoke(implInstance, args);
							} else {
								System.out
									.println("SQLインタフェースコンテナ制御コマンドの起動に失敗："
										+ "実装クラスインスタンスを取得できませんでした");
							}
						} catch (Exception e) {
							System.out.println("SQLインタフェースコンテナ制御コマンドの起動に失敗："
								+ e.getMessage());
						}
					}
					
					break;
				}
			}
			
			throw new IllegalStateException(
				"認識不能なSQLインタフェースコンテナ制御コマンドを受信しました： コマンド名["
					+ method.getName()
					+ "]");
			
			//			Class<?> returnType = method.getReturnType();
			//			
			//			if (returnType.equals(int.class)) {
			//				return 0;
			//			} else if (returnType.equals(short.class)) {
			//				short s = 0;
			//				return Short.valueOf(s);
			//			} else if (returnType.equals(long.class)) {
			//				return 0;
			//			} else if (returnType.equals(float.class)) {
			//				return 0.0;
			//			} else if (returnType.equals(double.class)) {
			//				return 0.0;
			//			} else if (returnType.equals(byte.class)) {
			//				return 0x00;
			//			} else if (returnType.equals(boolean.class)) {
			//				return false;
			//			} else if (returnType.equals(char.class)) {
			//				char c = new Character(' ');
			//				return c;
			//			} else if (returnType.equals(void.class)) {
			//				return null;
			//			} else {
			//				return null;
			//			}
		}
	}
	
	@Override
	public String toString() {
		return "hello";
	}
	
	@Override
	public boolean accept(final Method method) {
		for (CommandAcceptor acceptor : this.acceptors) {
			if (acceptor.accept(method)) {
				return true;
			}
		}
		return false;
		
	}
}
