package org.dyndns.nuda.mapper.connection;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import org.dyndns.nuda.mapper.ColumnInfo;
import org.dyndns.nuda.mapper.DaoHelper;
import org.dyndns.nuda.mapper.SQLInterfaceBean;

/**
 * トランザクションイベント発行可能なPreparedStatementオブジェクトです
 * 
 * @author nkoseki
 * 
 */
public class SQLInterfacePreparedStatement implements PreparedStatement {
	private PreparedStatement	pstmt			= null;
	private SQLInterfaceBean	interfaceBean	= null;
	
	public SQLInterfaceBean getInterfaceBean() {
		return this.interfaceBean;
	}
	
	private Map<String, ColumnInfo>	columnMap	=
													new HashMap<String, ColumnInfo>();
	
	public void setInterfaceBean(final SQLInterfaceBean interfaceBean) {
		this.interfaceBean = interfaceBean;
		
		try {
			if (this.interfaceBean.type.equals("INSERT")) {
				DatabaseMetaData metaData =
					this.pstmt.getConnection().getMetaData();
				
				String tableName = "CMM_COMIC_MASTER";
				
				ResultSet rs = metaData.getColumns(null, null, tableName, "%");
				
				try {
					while (rs.next()) {
						ColumnInfo info =
							DaoHelper.convertResult(rs, ColumnInfo.class);
						
						this.columnMap.put(info.getCOLUMN_NAME(), info);
					}
				} finally {
					rs.close();
				}
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}
	
	public SQLInterfacePreparedStatement(final PreparedStatement pstmt) {
		this.pstmt = pstmt;
	}
	
	@Override
	public ResultSet executeQuery(final String sql) throws SQLException {
		return this.pstmt.executeQuery(sql);
	}
	
	@Override
	public <T> T unwrap(final Class<T> iface) throws SQLException {
		return this.pstmt.unwrap(iface);
	}
	
	@Override
	public ResultSet executeQuery() throws SQLException {
		return this.pstmt.executeQuery();
	}
	
	@Override
	public int executeUpdate(final String sql) throws SQLException {
		return this.pstmt.executeUpdate(sql);
	}
	
	@Override
	public boolean isWrapperFor(final Class<?> iface) throws SQLException {
		return this.pstmt.isWrapperFor(iface);
	}
	
	@Override
	public int executeUpdate() throws SQLException {
		return this.pstmt.executeUpdate();
	}
	
	@Override
	public void close() throws SQLException {
		
		this.pstmt.close();
	}
	
	@Override
	public void setNull(final int parameterIndex, final int sqlType)
			throws SQLException {
		this.pstmt.setNull(parameterIndex, sqlType);
	}
	
	@Override
	public int getMaxFieldSize() throws SQLException {
		return this.pstmt.getMaxFieldSize();
	}
	
	@Override
	public void setBoolean(final int parameterIndex, final boolean x)
			throws SQLException {
		this.pstmt.setBoolean(parameterIndex, x);
	}
	
	@Override
	public void setMaxFieldSize(final int max) throws SQLException {
		this.pstmt.setMaxFieldSize(max);
	}
	
	@Override
	public void setByte(final int parameterIndex, final byte x)
			throws SQLException {
		this.pstmt.setByte(parameterIndex, x);
	}
	
	@Override
	public void setShort(final int parameterIndex, final short x)
			throws SQLException {
		this.pstmt.setShort(parameterIndex, x);
	}
	
	@Override
	public int getMaxRows() throws SQLException {
		return this.pstmt.getMaxRows();
	}
	
	@Override
	public void setInt(final int parameterIndex, final int x)
			throws SQLException {
		this.pstmt.setInt(parameterIndex, x);
	}
	
	@Override
	public void setMaxRows(final int max) throws SQLException {
		this.pstmt.setMaxRows(max);
	}
	
	@Override
	public void setLong(final int parameterIndex, final long x)
			throws SQLException {
		this.pstmt.setLong(parameterIndex, x);
	}
	
	@Override
	public void setEscapeProcessing(final boolean enable) throws SQLException {
		this.pstmt.setEscapeProcessing(enable);
	}
	
	@Override
	public void setFloat(final int parameterIndex, final float x)
			throws SQLException {
		this.pstmt.setFloat(parameterIndex, x);
	}
	
	@Override
	public int getQueryTimeout() throws SQLException {
		return this.pstmt.getQueryTimeout();
	}
	
	@Override
	public void setDouble(final int parameterIndex, final double x)
			throws SQLException {
		this.pstmt.setDouble(parameterIndex, x);
	}
	
	@Override
	public void setQueryTimeout(final int seconds) throws SQLException {
		this.pstmt.setQueryTimeout(seconds);
	}
	
	@Override
	public void setBigDecimal(final int parameterIndex, final BigDecimal x)
			throws SQLException {
		this.pstmt.setBigDecimal(parameterIndex, x);
	}
	
	@Override
	public void cancel() throws SQLException {
		this.pstmt.cancel();
	}
	
	@Override
	public void setString(final int parameterIndex, final String x)
			throws SQLException {
		
		this.pstmt.setString(parameterIndex, x);
	}
	
	@Override
	public SQLWarning getWarnings() throws SQLException {
		return this.pstmt.getWarnings();
	}
	
	@Override
	public void setBytes(final int parameterIndex, final byte[] x)
			throws SQLException {
		this.pstmt.setBytes(parameterIndex, x);
	}
	
	@Override
	public void clearWarnings() throws SQLException {
		this.pstmt.clearWarnings();
	}
	
	@Override
	public void setDate(final int parameterIndex, final Date x)
			throws SQLException {
		this.pstmt.setDate(parameterIndex, x);
	}
	
	@Override
	public void setCursorName(final String name) throws SQLException {
		this.pstmt.setCursorName(name);
	}
	
	@Override
	public void setTime(final int parameterIndex, final Time x)
			throws SQLException {
		this.pstmt.setTime(parameterIndex, x);
	}
	
	@Override
	public void setTimestamp(final int parameterIndex, final Timestamp x)
			throws SQLException {
		this.pstmt.setTimestamp(parameterIndex, x);
	}
	
	@Override
	public boolean execute(final String sql) throws SQLException {
		return this.pstmt.execute(sql);
	}
	
	@Override
	public void setAsciiStream(final int parameterIndex, final InputStream x,
			final int length) throws SQLException {
		this.pstmt.setAsciiStream(parameterIndex, x, length);
	}
	
	@Override
	public ResultSet getResultSet() throws SQLException {
		return this.pstmt.getResultSet();
	}
	
	@Override
	public void setUnicodeStream(final int parameterIndex, final InputStream x,
			final int length) throws SQLException {
		this.pstmt.setUnicodeStream(parameterIndex, x, length);
	}
	
	@Override
	public int getUpdateCount() throws SQLException {
		return this.pstmt.getUpdateCount();
	}
	
	@Override
	public boolean getMoreResults() throws SQLException {
		return this.pstmt.getMoreResults();
	}
	
	@Override
	public void setBinaryStream(final int parameterIndex, final InputStream x,
			final int length) throws SQLException {
		this.pstmt.setBinaryStream(parameterIndex, x, length);
	}
	
	@Override
	public void setFetchDirection(final int direction) throws SQLException {
		this.pstmt.setFetchDirection(direction);
	}
	
	@Override
	public void clearParameters() throws SQLException {
		this.pstmt.clearParameters();
	}
	
	@Override
	public int getFetchDirection() throws SQLException {
		return this.pstmt.getFetchDirection();
	}
	
	@Override
	public void setObject(final int parameterIndex, final Object x,
			final int targetSqlType) throws SQLException {
		this.pstmt.setObject(parameterIndex, x, targetSqlType);
	}
	
	@Override
	public void setFetchSize(final int rows) throws SQLException {
		this.pstmt.setFetchSize(rows);
	}
	
	@Override
	public int getFetchSize() throws SQLException {
		return this.pstmt.getFetchSize();
	}
	
	@Override
	public void setObject(final int parameterIndex, final Object x)
			throws SQLException {
		this.pstmt.setObject(parameterIndex, x);
	}
	
	@Override
	public int getResultSetConcurrency() throws SQLException {
		return this.pstmt.getResultSetConcurrency();
	}
	
	@Override
	public int getResultSetType() throws SQLException {
		return this.pstmt.getResultSetType();
	}
	
	@Override
	public void addBatch(final String sql) throws SQLException {
		this.pstmt.addBatch(sql);
	}
	
	@Override
	public void clearBatch() throws SQLException {
		this.pstmt.clearBatch();
	}
	
	@Override
	public boolean execute() throws SQLException {
		return this.pstmt.execute();
	}
	
	@Override
	public int[] executeBatch() throws SQLException {
		int[] result = this.pstmt.executeBatch();
		
		return result;
	}
	
	@Override
	public void addBatch() throws SQLException {
		this.pstmt.addBatch();
	}
	
	@Override
	public void setCharacterStream(final int parameterIndex,
			final Reader reader, final int length) throws SQLException {
		this.pstmt.setCharacterStream(parameterIndex, reader, length);
	}
	
	@Override
	public void setRef(final int parameterIndex, final Ref x)
			throws SQLException {
		this.pstmt.setRef(parameterIndex, x);
	}
	
	@Override
	public Connection getConnection() throws SQLException {
		return this.pstmt.getConnection();
	}
	
	@Override
	public void setBlob(final int parameterIndex, final Blob x)
			throws SQLException {
		this.pstmt.setBlob(parameterIndex, x);
	}
	
	@Override
	public void setClob(final int parameterIndex, final Clob x)
			throws SQLException {
		this.pstmt.setClob(parameterIndex, x);
	}
	
	@Override
	public boolean getMoreResults(final int current) throws SQLException {
		return this.pstmt.getMoreResults(current);
	}
	
	@Override
	public void setArray(final int parameterIndex, final Array x)
			throws SQLException {
		this.pstmt.setArray(parameterIndex, x);
	}
	
	@Override
	public ResultSetMetaData getMetaData() throws SQLException {
		return this.pstmt.getMetaData();
	}
	
	@Override
	public ResultSet getGeneratedKeys() throws SQLException {
		return this.pstmt.getGeneratedKeys();
	}
	
	@Override
	public void setDate(final int parameterIndex, final Date x,
			final Calendar cal) throws SQLException {
		this.pstmt.setDate(parameterIndex, x, cal);
	}
	
	@Override
	public int executeUpdate(final String sql, final int autoGeneratedKeys)
			throws SQLException {
		return this.pstmt.executeUpdate(sql, autoGeneratedKeys);
	}
	
	@Override
	public void setTime(final int parameterIndex, final Time x,
			final Calendar cal) throws SQLException {
		this.pstmt.setTime(parameterIndex, x, cal);
	}
	
	@Override
	public int executeUpdate(final String sql, final int[] columnIndexes)
			throws SQLException {
		return this.pstmt.executeUpdate(sql, columnIndexes);
	}
	
	@Override
	public void setTimestamp(final int parameterIndex, final Timestamp x,
			final Calendar cal) throws SQLException {
		this.pstmt.setTimestamp(parameterIndex, x, cal);
	}
	
	@Override
	public void setNull(final int parameterIndex, final int sqlType,
			final String typeName) throws SQLException {
		this.pstmt.setNull(parameterIndex, sqlType, typeName);
	}
	
	@Override
	public int executeUpdate(final String sql, final String[] columnNames)
			throws SQLException {
		return this.pstmt.executeUpdate(sql, columnNames);
	}
	
	@Override
	public boolean execute(final String sql, final int autoGeneratedKeys)
			throws SQLException {
		return this.pstmt.execute(sql, autoGeneratedKeys);
	}
	
	@Override
	public void setURL(final int parameterIndex, final URL x)
			throws SQLException {
		this.pstmt.setURL(parameterIndex, x);
	}
	
	@Override
	public ParameterMetaData getParameterMetaData() throws SQLException {
		return this.pstmt.getParameterMetaData();
	}
	
	@Override
	public void setRowId(final int parameterIndex, final RowId x)
			throws SQLException {
		this.pstmt.setRowId(parameterIndex, x);
	}
	
	@Override
	public boolean execute(final String sql, final int[] columnIndexes)
			throws SQLException {
		return this.pstmt.execute(sql, columnIndexes);
	}
	
	@Override
	public void setNString(final int parameterIndex, final String value)
			throws SQLException {
		this.pstmt.setNString(parameterIndex, value);
	}
	
	@Override
	public void setNCharacterStream(final int parameterIndex,
			final Reader value, final long length) throws SQLException {
		this.pstmt.setNCharacterStream(parameterIndex, value, length);
	}
	
	@Override
	public boolean execute(final String sql, final String[] columnNames)
			throws SQLException {
		return this.pstmt.execute(sql, columnNames);
	}
	
	@Override
	public void setNClob(final int parameterIndex, final NClob value)
			throws SQLException {
		this.pstmt.setNClob(parameterIndex, value);
	}
	
	@Override
	public void setClob(final int parameterIndex, final Reader reader,
			final long length) throws SQLException {
		this.pstmt.setClob(parameterIndex, reader, length);
	}
	
	@Override
	public int getResultSetHoldability() throws SQLException {
		return this.pstmt.getResultSetHoldability();
	}
	
	@Override
	public void setBlob(final int parameterIndex,
			final InputStream inputStream, final long length)
			throws SQLException {
		this.pstmt.setBlob(parameterIndex, inputStream, length);
	}
	
	@Override
	public boolean isClosed() throws SQLException {
		return this.pstmt.isClosed();
	}
	
	@Override
	public void setPoolable(final boolean poolable) throws SQLException {
		this.pstmt.setPoolable(poolable);
	}
	
	@Override
	public void setNClob(final int parameterIndex, final Reader reader,
			final long length) throws SQLException {
		this.pstmt.setNClob(parameterIndex, reader, length);
	}
	
	@Override
	public boolean isPoolable() throws SQLException {
		return this.pstmt.isPoolable();
	}
	
	@Override
	public void setSQLXML(final int parameterIndex, final SQLXML xmlObject)
			throws SQLException {
		this.pstmt.setSQLXML(parameterIndex, xmlObject);
	}
	
	@Override
	public void setObject(final int parameterIndex, final Object x,
			final int targetSqlType, final int scaleOrLength)
			throws SQLException {
		this.pstmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
	}
	
	@Override
	public void setAsciiStream(final int parameterIndex, final InputStream x,
			final long length) throws SQLException {
		this.pstmt.setAsciiStream(parameterIndex, x, length);
	}
	
	@Override
	public void setBinaryStream(final int parameterIndex, final InputStream x,
			final long length) throws SQLException {
		this.pstmt.setBinaryStream(parameterIndex, x, length);
	}
	
	@Override
	public void setCharacterStream(final int parameterIndex,
			final Reader reader, final long length) throws SQLException {
		this.pstmt.setCharacterStream(parameterIndex, reader, length);
	}
	
	@Override
	public void setAsciiStream(final int parameterIndex, final InputStream x)
			throws SQLException {
		this.pstmt.setAsciiStream(parameterIndex, x);
	}
	
	@Override
	public void setBinaryStream(final int parameterIndex, final InputStream x)
			throws SQLException {
		this.pstmt.setBinaryStream(parameterIndex, x);
	}
	
	@Override
	public void setCharacterStream(final int parameterIndex, final Reader reader)
			throws SQLException {
		this.pstmt.setCharacterStream(parameterIndex, reader);
	}
	
	@Override
	public void setNCharacterStream(final int parameterIndex, final Reader value)
			throws SQLException {
		this.pstmt.setNCharacterStream(parameterIndex, value);
	}
	
	@Override
	public void setClob(final int parameterIndex, final Reader reader)
			throws SQLException {
		this.pstmt.setClob(parameterIndex, reader);
	}
	
	@Override
	public void setBlob(final int parameterIndex, final InputStream inputStream)
			throws SQLException {
		this.pstmt.setBlob(parameterIndex, inputStream);
	}
	
	@Override
	public void setNClob(final int parameterIndex, final Reader reader)
			throws SQLException {
		this.pstmt.setNClob(parameterIndex, reader);
	}
	
}
