package org.dyndns.nuda.sormap.sample;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.dyndns.nuda.mapper.SQLInterfaceBean;
import org.dyndns.nuda.mapper.SQLInterfaceFactory;
import org.dyndns.nuda.mapper.event.SQLInterfaceEventListener;
import org.dyndns.nuda.mapper.event.SQLInterfaceEventProcessor;
import org.dyndns.nuda.mapper.event.implementation.DeleteEvent;
import org.dyndns.nuda.mapper.event.implementation.InsertEvent;
import org.dyndns.nuda.mapper.event.implementation.ManualTransactionEvent;
import org.dyndns.nuda.mapper.event.implementation.UpdateEvent;
import org.dyndns.nuda.mapper.helper.CommandDataPair;

public class TestMainV030 {
	
	/**
	 * @param args
	 */
	public static void main(final String[] args) throws Exception {
		Connection con =
			DriverManager
				.getConnection("jdbc:sormap://localhost:3306/testdb?subProtocol=mysql");
		
	}
	
	/**
	 * useAutoCommit:false
	 * useManualTransaction:false
	 * の場合
	 */
	public static void case01(final Connection con) {
		SampleInterface intf =
			SQLInterfaceFactory.newInstance().connection(con) // コネクションオブジェクトを指定
				.useAutoCommit(false)
				// 自動コミットモードオフ
				.useManualTransaction(false)
				// ユーザベーストランザクション制御オフ
				.create(SampleInterface.class); // SQLInterfaceを生成
		
		// 以下の３つのイベントハンドラは
		// useAutoCommit = false
		// useManualTransaction = false
		// 時に有効
		SQLInterfaceEventProcessor
			.newInstance()
			.addEventListener(new SQLInterfaceEventListener<InsertEvent>() {
				// INSERT→コミット完了時にトリガーされる
				@Override
				public void handle(final InsertEvent event) {
					// INSERTされたデータがListにJavaBeansとして入ってくる
					// 処理するにはキャストしてやる必要がある
					List<?> resultList = event.getInsertedObjects();
					
					// クエリ文字列やプレースホルダマッピング情報などを
					// 格納するJavaBeans
					SQLInterfaceBean intfBean = event.getInterfaceBean();
					
				}
			})
			.addEventListener(new SQLInterfaceEventListener<UpdateEvent>() {
				// UPDATE→コミット完了時にトリガーされる
				@Override
				public void handle(final UpdateEvent event) {
					// INSERTされたデータがListにJavaBeansとして入ってくる
					// 処理するにはキャストしてやる必要がある
					List<?> resultList = event.getUpdatedObjects();
					
					// クエリ文字列やプレースホルダマッピング情報などを
					// 格納するJavaBeans
					SQLInterfaceBean intfBean = event.getInterfaceBean();
					
				}
			})
			.addEventListener(new SQLInterfaceEventListener<DeleteEvent>() {
				// DELETE→コミット完了時にトリガーされる
				@Override
				public void handle(final DeleteEvent event) {
					// INSERTされたデータがListにJavaBeansとして入ってくる
					// 処理するにはキャストしてやる必要がある
					List<?> resultList = event.getDeletedObjects();
					
					// クエリ文字列やプレースホルダマッピング情報などを
					// 格納するJavaBeans
					SQLInterfaceBean intfBean = event.getInterfaceBean();
					
				}
			});
		
		intf.insert(new ArrayList<TestSchemeBean>());
		
		intf.update(new ArrayList<TestSchemeBean>());
		
		intf.delete(new ArrayList<TestSchemeBean>());
		
	}
	
	public void case02(final Connection con) {
		SampleInterface intf =
			SQLInterfaceFactory.newInstance().connection(con) // コネクションオブジェクトを指定
				.useAutoCommit(true)
				// 自動コミットモードオフ
				.useManualTransaction(true)
				// ユーザベーストランザクション制御オフ
				.create(SampleInterface.class); // SQLInterfaceを生成
		
		// 以下の３つのイベントハンドラは
		// useAutoCommit = false
		// useManualTransaction = false
		// 時に有効
		SQLInterfaceEventProcessor.newInstance().addEventListener(
			new SQLInterfaceEventListener<ManualTransactionEvent>() {
				
				@Override
				public void handle(final ManualTransactionEvent arg0) {
					
					List<CommandDataPair> pair = arg0.pair;
					String state = arg0.state; // commit/rollbackを取りうる
					
					CommandDataPair command = pair.get(0);
					
					SQLInterfaceBean intfBean = command.getSqlInterfaceBean();
					List<Object> resultList = command.getData();
				}
			});
		
		intf.insert(new ArrayList<TestSchemeBean>());
		
		intf.update(new ArrayList<TestSchemeBean>());
		
		intf.delete(new ArrayList<TestSchemeBean>());
		
		try {
			con.setAutoCommit(true);
			
			// この時点ｔんでManualTransactionEvent
			// Commit
			con.commit();
		} catch (SQLException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			try {
				con.rollback();
			} catch (SQLException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
			}
		}
	}
}
