package org.dyndns.nuda.mapper.helper.command;

import java.sql.SQLException;

import org.dyndns.nuda.mapper.helper.SQLInterfaceControllerCommand;

/**
 * JDBCコネクションのトランザクションを制御するためのSQLインタフェースコンテナ制御コマンドです
 * 
 * @author nkoseki
 * 
 */
public interface TransactionCommand extends SQLInterfaceControllerCommand {
	
	/**
	 * トランザクションをコミットします
	 * 
	 * @throws SQLException
	 */
	public void commit() throws SQLException;
	
	/**
	 * トランザクションをロールバックしますｓ
	 * 
	 * @throws SQLException
	 */
	public void rollback() throws SQLException;
}
