package org.dyndns.nuda.mapper.helper.command;

import java.sql.Connection;

import org.dyndns.nuda.mapper.JDBCXMLInvocationHandler;

/**
 * SQLインタフェースコンテナ制御コマンド：コネクション取得
 * 
 * @see org.dyndns.nuda.mapper.helper.command.GetConnectionComamnd
 * @author nkoseki
 * 
 */
public class GetConnectionCommandImpl implements GetConnectionCommand {
	private JDBCXMLInvocationHandler	container;
	
	@Override
	public void setContainer(final JDBCXMLInvocationHandler container) {
		this.container = container;
		
	}
	
	@Override
	public JDBCXMLInvocationHandler getContainer() {
		return this.container;
	}
	
	@Override
	public Connection getConnection() {
		if (this.container != null) {
			return this.container.getConnection();
		} else {
			//			System.out
			//				.println("GetConnectionCommandImpl#getConnection [コンテナが存在しないためコマンドの起動に失敗しました]");
			return null;
		}
	}
	
}
