package org.dyndns.nuda.mapper.helper;

import java.lang.reflect.Method;

/**
 * コマンド要求を受領するかをテストするためのインタフェースです
 * 
 * @author nkoseki
 * 
 */
public interface CommandAcceptor {
	
	/**
	 * 引数に指定されたメソッドオブジェクトが指し示すコマンドオブジェクトをこのインスタンスが許容するかテストします
	 * 
	 * @param method
	 *            メソッドオブジェクト
	 * @return 許容する:true / 許容しない:false
	 */
	public boolean accept(Method method);
	
	/**
	 * このインスタンスの生成元を表すクラスオブジェクトを返します
	 * 
	 * @return このインスタンスの生成元クラスオブジェクト
	 */
	public Class<?> getDeclaredClass();
}
