/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.helper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dyndns.nuda.mapper.JDBCXMLInvocationHandler;
import org.dyndns.nuda.mapper.helper.CommandAcceptor;
import org.dyndns.nuda.mapper.helper.CommandAcceptorHelper;
import org.dyndns.nuda.mapper.helper.CommandSigniture;
import org.dyndns.nuda.mapper.helper.SQLInterfaceControllerCommand;
import org.dyndns.nuda.mapper.helper.command.AcceptCommand;
import org.dyndns.nuda.mapper.helper.xml.SQLInterfaceCommandResultBean;
import org.dyndns.nuda.mapper.helper.xml.SQLInterfaceCommandXMLBean;
import org.dyndns.nuda.mapper.helper.xml.SQLXMLInterfaceCommandScope;
import org.dyndns.nuda.tools.xml.Context;
import org.dyndns.nuda.tools.xml.DefaultXMLReader;
import org.dyndns.nuda.tools.xml.ScopeHandler;

public class SQLInterfaceCommandInvocationHandler
implements SQLInterfaceControllerCommand,
AcceptCommand,
InvocationHandler {
    private JDBCXMLInvocationHandler container;
    private Map<Class<?>, Class<?>> implementationMap = new HashMap();
    private Map<Class<?>, Object> implInstanceMap = new HashMap();
    private CommandSigniture acceptCommandSigniture = null;
    private List<CommandAcceptor> acceptors = null;

    public SQLInterfaceCommandInvocationHandler(JDBCXMLInvocationHandler container) {
        this.container = container;
        this.initIH();
    }

    @Override
    public void setContainer(JDBCXMLInvocationHandler container) {
        this.container = container;
    }

    private void initIH() {
        try {
            Method acceptMethod = this.getClass().getDeclaredMethod("accept", Method.class);
            this.acceptCommandSigniture = new CommandSigniture(acceptMethod);
        }
        catch (SecurityException e) {
            System.out.println("SQL\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u30b3\u30f3\u30c6\u30ca\u5236\u5fa1\u30b3\u30de\u30f3\u30c9\uff1aaccept \u8a2d\u5b9a\u51e6\u7406\uff1a\u5931\u6557[" + e.getMessage() + "]");
        }
        catch (NoSuchMethodException e) {
            System.out.println("SQL\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u30b3\u30f3\u30c6\u30ca\u5236\u5fa1\u30b3\u30de\u30f3\u30c9\uff1aaccept \u8a2d\u5b9a\u51e6\u7406\uff1a\u5931\u6557[" + e.getMessage() + "]");
        }
        Context ctx = new Context();
        ctx.setValue((Object)new SQLInterfaceCommandResultBean());
        DefaultXMLReader reader = new DefaultXMLReader((ScopeHandler)SQLXMLInterfaceCommandScope.SQLInterfaceCommand, ctx);
        reader.read("interface-command.xml");
        SQLInterfaceCommandResultBean resultBean = (SQLInterfaceCommandResultBean)reader.getResult();
        for (SQLInterfaceCommandXMLBean xmlBean : resultBean.beans) {
            try {
                Class<?> intf = Class.forName(xmlBean.type);
                Class<?> implementation = Class.forName(xmlBean.implementation);
                this.implementationMap.put(intf, implementation);
            }
            catch (ClassNotFoundException e) {
                System.out.println("SQL\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u30b3\u30f3\u30c6\u30ca\u5236\u5fa1\u30b3\u30de\u30f3\u30c9\u30af\u30e9\u30b9\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\uff1a" + e.getMessage());
            }
        }
    }

    @Override
    public JDBCXMLInvocationHandler getContainer() {
        try {
            Method acceptMethod = this.getClass().getDeclaredMethod("accept", Method.class);
            this.acceptCommandSigniture = new CommandSigniture(acceptMethod);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return this.container;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> proxyClass = proxy.getClass();
        CommandSigniture currentCommandSigniture = new CommandSigniture(method);
        if (this.acceptors == null || this.acceptors.size() == 0) {
            this.acceptors = new ArrayList<CommandAcceptor>();
            Class<?>[] classArray = proxyClass.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> c = classArray[n2];
                this.acceptors.add(CommandAcceptorHelper.getAcceptor(c));
                ++n2;
            }
        }
        if (method.getName().equals("toString")) {
            return this.toString();
        }
        if (this.acceptCommandSigniture.equals(currentCommandSigniture)) {
            if (args.length == 0 || args[0] == null) {
                return this.accept(null);
            }
            return this.accept((Method)args[0]);
        }
        for (CommandAcceptor acceptor : this.acceptors) {
            if (!acceptor.accept(method)) continue;
            Class<?> decClass = acceptor.getDeclaredClass();
            Class<?> implClass = this.implementationMap.get(decClass);
            if (implClass == null) {
                System.out.println("\u30e1\u30bd\u30c3\u30c9\u540d\uff1a[" + method.getName() + "] accept by [" + decClass.getCanonicalName() + "] \u5b9f\u88c5=[\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f]");
                break;
            }
            try {
                Object implInstance = null;
                if (!this.implInstanceMap.containsKey(decClass)) {
                    implInstance = implClass.newInstance();
                    this.implInstanceMap.put(decClass, implInstance);
                    if (implInstance instanceof SQLInterfaceControllerCommand) {
                        SQLInterfaceControllerCommand c = (SQLInterfaceControllerCommand)implInstance;
                        c.setContainer(this.container);
                    }
                } else {
                    implInstance = this.implInstanceMap.get(decClass);
                }
                if (implInstance != null) {
                    return method.invoke(implInstance, args);
                }
                System.out.println("SQL\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u30b3\u30f3\u30c6\u30ca\u5236\u5fa1\u30b3\u30de\u30f3\u30c9\u306e\u8d77\u52d5\u306b\u5931\u6557\uff1a\u5b9f\u88c5\u30af\u30e9\u30b9\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
            }
            catch (Exception e) {
                System.out.println("SQL\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u30b3\u30f3\u30c6\u30ca\u5236\u5fa1\u30b3\u30de\u30f3\u30c9\u306e\u8d77\u52d5\u306b\u5931\u6557\uff1a" + e.getMessage());
            }
            break;
        }
        throw new IllegalStateException("\u8a8d\u8b58\u4e0d\u80fd\u306aSQL\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u30b3\u30f3\u30c6\u30ca\u5236\u5fa1\u30b3\u30de\u30f3\u30c9\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\uff1a \u30b3\u30de\u30f3\u30c9\u540d[" + method.getName() + "]");
    }

    public String toString() {
        return "hello";
    }

    @Override
    public boolean accept(Method method) {
        for (CommandAcceptor acceptor : this.acceptors) {
            if (!acceptor.accept(method)) continue;
            return true;
        }
        return false;
    }
}

