/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dyndns.nuda.mapper.DaoHelper;
import org.dyndns.nuda.mapper.QueryCondition;
import org.dyndns.nuda.mapper.QueryXMLBean;
import org.dyndns.nuda.mapper.QueryXMLReader;
import org.dyndns.nuda.mapper.SQLInterfaceBean;
import org.dyndns.nuda.mapper.annotation.JDBCQuery;
import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;
import org.dyndns.nuda.mapper.connection.SQLInterfacePreparedStatement;
import org.dyndns.nuda.mapper.event.SQLInterfaceEvent;
import org.dyndns.nuda.mapper.event.SQLInterfaceEventProcessor;
import org.dyndns.nuda.mapper.event.implementation.DeleteEvent;
import org.dyndns.nuda.mapper.event.implementation.InsertEvent;
import org.dyndns.nuda.mapper.event.implementation.RollBackEvent;
import org.dyndns.nuda.mapper.event.implementation.UpdateEvent;
import org.dyndns.nuda.mapper.helper.CommandDataPair;
import org.dyndns.nuda.mapper.helper.SQLInterfaceCommandInvocationHandler;
import org.dyndns.nuda.mapper.helper.command.AcceptCommand;
import org.dyndns.nuda.mapper.helper.xml.SQLInterfaceCommandResultBean;
import org.dyndns.nuda.mapper.helper.xml.SQLInterfaceCommandXMLBean;
import org.dyndns.nuda.mapper.helper.xml.SQLXMLInterfaceCommandScope;
import org.dyndns.nuda.tools.util.ReflectUtil;
import org.dyndns.nuda.tools.util.StringUtil;
import org.dyndns.nuda.tools.xml.Context;
import org.dyndns.nuda.tools.xml.DefaultXMLReader;
import org.dyndns.nuda.tools.xml.ScopeHandler;

public class JDBCXMLInvocationHandler
implements InvocationHandler {
    private List<SQLInterfaceBean> queryBeans = new ArrayList<SQLInterfaceBean>();
    private SQLInterfaceConnection con = null;
    private boolean useAutoCommit = true;
    private boolean manualTransaction = false;
    public static final int FLAGS = 40;
    private Object ctrlCommandProxy = null;
    private AcceptCommand commandAcceptor = null;
    private static final String QST = "?";
    private static final String SPACE = " ";
    private static final String BLANK = "";
    private static final String p1StrSub = "(like|=|>|<|<=|>=)\\s+?(\\S+?\\s*?/\\*.+?\\*/)";
    private static final String p2Str = "(\\S+?\\s*/\\*\\s*?(.+?)\\s*?\\*/)";
    private static final String p1InsStr = "((\\d+|'.*?')\\s*?(/\\*.+?\\*/))";
    private static final Pattern P1INS = Pattern.compile("((\\d+|'.*?')\\s*?(/\\*.+?\\*/))", 40);
    private static final String p2InsStr = "((\\S+?\\s*|'.+')\\s*?/\\*\\s*?(.+?)\\s*?\\*/)";
    private static final Pattern P2INS = Pattern.compile("((\\S+?\\s*|'.+')\\s*?/\\*\\s*?(.+?)\\s*?\\*/)", 40);
    private static final Pattern P1 = Pattern.compile("(like|=|>|<|<=|>=)\\s+?(\\S+?\\s*?/\\*.+?\\*/)");
    private static final Pattern P2 = Pattern.compile("(\\S+?\\s*/\\*\\s*?(.+?)\\s*?\\*/)", 40);
    private static Map<String, SQLInterfacePreparedStatement> prepareCache = new HashMap<String, SQLInterfacePreparedStatement>();

    public void setConnection(SQLInterfaceConnection con) {
        this.con = con;
    }

    public boolean isUseAutoCommit() {
        return this.useAutoCommit;
    }

    public void setUseAutoCommit(boolean useAutoCommit) {
        this.useAutoCommit = useAutoCommit;
    }

    public boolean isManualTransaction() {
        return this.manualTransaction;
    }

    public void setManualTransaction(boolean manualTransaction) {
        this.manualTransaction = manualTransaction;
    }

    public Connection getConnection() {
        return this.con;
    }

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass) throws Exception {
        this.initContainer(con, handlerClass, true, false);
    }

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass, boolean useAutoCommit) throws Exception {
        this.initContainer(con, handlerClass, useAutoCommit, false);
    }

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass, boolean useAutoCommit, boolean manualTransaction) throws Exception {
        this.initContainer(con, handlerClass, useAutoCommit, manualTransaction);
    }

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass, ClassLoader currentClassLoader, boolean useAutoCommit, boolean manualTransaction) throws Exception {
        this.initContainer(con, handlerClass, currentClassLoader, useAutoCommit, manualTransaction);
        this.initSQLIFCtrlCommand();
    }

    private void initContainer(Connection con, Class<?> handlerClass, boolean useAutoCommit, boolean manualTransaction) throws Exception {
        if (handlerClass == null) {
            return;
        }
        if (!handlerClass.isInterface()) {
            String format = "unsupported class {}. class is not a interface";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            throw new Exception(message);
        }
        if (handlerClass.isAnnotationPresent(JDBCQuery.class)) {
            if (con instanceof SQLInterfaceConnection) {
                SQLInterfaceConnection sourceConnection = (SQLInterfaceConnection)con;
                this.con = (SQLInterfaceConnection)con;
            } else {
                this.con = new SQLInterfaceConnection(con);
            }
            this.con.setUseManualTransaction(manualTransaction);
            this.manualTransaction = manualTransaction;
            this.useAutoCommit = useAutoCommit;
            JDBCQuery query = handlerClass.getAnnotation(JDBCQuery.class);
            String xmlPath = query.sqlxml();
            QueryXMLReader reader = new QueryXMLReader();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlPath);
            reader.read(is);
            List<QueryXMLBean> result = reader.getResult();
            for (QueryXMLBean xmlBean : result) {
                SQLInterfaceBean inBean = this.convertSQLFromXML(xmlBean.getType(), xmlBean.getSql());
                inBean.id = xmlBean.getId();
                inBean.type = xmlBean.getType();
                this.queryBeans.add(inBean);
            }
        } else {
            String format = "unsupported class {}. class is not supported annotation<org.dyndns.nuda.repserv.datastore.annotation.JDBCQuery>";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            throw new Exception(message);
        }
    }

    private void initContainer(Connection con, Class<?> handlerClass, ClassLoader currentClassLoader, boolean useAutoCommit, boolean manualTransaction) throws Exception {
        if (handlerClass == null) {
            return;
        }
        if (!handlerClass.isInterface()) {
            String format = "unsupported class {}. class is not a interface";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            throw new Exception(message);
        }
        if (handlerClass.isAnnotationPresent(JDBCQuery.class)) {
            SQLInterfaceConnection sourceConnection;
            this.con = con instanceof SQLInterfaceConnection ? (sourceConnection = (SQLInterfaceConnection)con) : new SQLInterfaceConnection(con);
            this.con.setUseManualTransaction(manualTransaction);
            this.manualTransaction = manualTransaction;
            this.useAutoCommit = useAutoCommit;
            JDBCQuery query = handlerClass.getAnnotation(JDBCQuery.class);
            String xmlPath = query.sqlxml();
            QueryXMLReader reader = new QueryXMLReader();
            InputStream is = null;
            is = currentClassLoader == null ? Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlPath) : currentClassLoader.getResourceAsStream(xmlPath);
            reader.read(is);
            List<QueryXMLBean> result = reader.getResult();
            for (QueryXMLBean xmlBean : result) {
                SQLInterfaceBean inBean = this.convertSQLFromXML(xmlBean.getType(), xmlBean.getSql());
                inBean.id = xmlBean.getId();
                inBean.type = xmlBean.getType();
                this.queryBeans.add(inBean);
            }
        } else {
            String format = "unsupported class {}. class is not supported annotation<org.dyndns.nuda.repserv.datastore.annotation.JDBCQuery>";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            throw new Exception(message);
        }
    }

    private void initSQLIFCtrlCommand() {
        Object proxy;
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        SQLInterfaceCommandInvocationHandler h = new SQLInterfaceCommandInvocationHandler(this);
        ArrayList commandList = new ArrayList();
        Context ctx = new Context();
        ctx.setValue((Object)new SQLInterfaceCommandResultBean());
        DefaultXMLReader reader = new DefaultXMLReader((ScopeHandler)SQLXMLInterfaceCommandScope.SQLInterfaceCommand, ctx);
        reader.read("interface-command.xml");
        SQLInterfaceCommandResultBean resultBean = (SQLInterfaceCommandResultBean)reader.getResult();
        for (SQLInterfaceCommandXMLBean xmlBean : resultBean.beans) {
            try {
                Class<?> intf = Class.forName(xmlBean.type);
                commandList.add(intf);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        commandList.add(AcceptCommand.class);
        this.ctrlCommandProxy = proxy = Proxy.newProxyInstance(l, commandList.toArray(new Class[commandList.size()]), (InvocationHandler)h);
        this.commandAcceptor = (AcceptCommand)proxy;
    }

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass, ClassLoader loader) throws Exception {
        System.out.println("default");
        if (handlerClass == null) {
            return;
        }
        if (!handlerClass.isInterface()) {
            String format = "unsupported class {}. class is not a interface";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            throw new Exception(message);
        }
        if (handlerClass.isAnnotationPresent(JDBCQuery.class)) {
            if (con instanceof SQLInterfaceConnection) {
                SQLInterfaceConnection sourceConnection = (SQLInterfaceConnection)con;
                this.con = new SQLInterfaceConnection(sourceConnection.getSourceConnection());
            } else {
                this.con = new SQLInterfaceConnection(con);
            }
            this.manualTransaction = false;
            this.con.setUseManualTransaction(false);
            JDBCQuery query = handlerClass.getAnnotation(JDBCQuery.class);
            String xmlPath = query.sqlxml();
            QueryXMLReader reader = new QueryXMLReader();
            InputStream is = loader.getResourceAsStream(xmlPath);
            reader.read(is);
            List<QueryXMLBean> result = reader.getResult();
            is.close();
            for (QueryXMLBean xmlBean : result) {
                SQLInterfaceBean inBean = this.convertSQLFromXML(xmlBean.getType(), xmlBean.getSql());
                inBean.id = xmlBean.getId();
                inBean.type = xmlBean.getType();
                this.queryBeans.add(inBean);
            }
        } else {
            String format = "unsupported class {}. class is not supported annotation<org.dyndns.nuda.repserv.datastore.annotation.JDBCQuery>";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            throw new Exception(message);
        }
    }

    private SQLInterfaceBean convertSQLFromXML(String queryType, String queryStr) {
        SQLInterfaceBean bean = new SQLInterfaceBean();
        if ("SELECT".equals(queryType)) {
            String source = queryStr;
            Matcher m = P1.matcher(source);
            String result0 = BLANK;
            HashMap<Integer, String> matchMap = new HashMap<Integer, String>();
            int matchIndex = 0;
            while (m.find()) {
                int startRegion = m.regionStart();
                int endRegion = m.regionEnd();
                Matcher subMatcher = m.region(startRegion, endRegion);
                subMatcher.usePattern(P2);
                while (subMatcher.find()) {
                    String result2;
                    String matchResult = subMatcher.group(2);
                    matchMap.put(matchIndex + 1, matchResult.replace(SPACE, BLANK));
                    result0 = result2 = subMatcher.replaceFirst(QST);
                    subMatcher.reset(result2);
                    ++matchIndex;
                }
            }
            if (result0.isEmpty()) {
                result0 = queryStr;
            }
            bean.sqlStr = result0;
            bean.map = matchMap;
        } else if ("INSERT".equals(queryType) || "UPDATE".equals(queryType) || "DELETE".equals(queryType)) {
            String source = queryStr;
            Matcher m = P1INS.matcher(source);
            String result0 = BLANK;
            HashMap<Integer, String> matchMap = new HashMap<Integer, String>();
            int matchIndex = 0;
            while (m.find()) {
                int startRegion = m.regionStart();
                int endRegion = m.regionEnd();
                Matcher subMatcher = m.region(startRegion, endRegion);
                subMatcher.usePattern(P2INS);
                while (subMatcher.find()) {
                    String result2;
                    String matchResult = subMatcher.group(3);
                    matchMap.put(matchIndex + 1, matchResult.replace(SPACE, BLANK));
                    result0 = result2 = subMatcher.replaceFirst(QST);
                    subMatcher.reset(result2);
                    ++matchIndex;
                }
            }
            if (result0.isEmpty()) {
                result0 = queryStr;
            }
            bean.sqlStr = result0;
            bean.map = matchMap;
        } else {
            bean.sqlStr = queryStr;
            bean.map = null;
        }
        return bean;
    }

    private void initStatement(SQLInterfaceBean inBean, PreparedStatement pstmt, Object parameter) throws Exception {
        block14: {
            if (inBean.map == null) break block14;
            for (Map.Entry<Integer, String> entry : inBean.map.entrySet()) {
                java.util.Date d;
                int index = entry.getKey();
                String propName = entry.getValue();
                if (parameter == null) continue;
                Object param01 = parameter;
                String realMethodName = ReflectUtil.PREFIX.GETTER.camelCaseTo(propName);
                Method getterMethod = null;
                getterMethod = param01.getClass().getDeclaredMethod(realMethodName, new Class[0]);
                Class<?> paramType = getterMethod.getReturnType();
                Object paramValue = getterMethod.invoke(param01, new Object[0]);
                if (paramType == Integer.TYPE) {
                    pstmt.setInt(index, (Integer)Integer.class.cast(paramValue));
                    continue;
                }
                if (paramType == String.class) {
                    pstmt.setString(index, (String)String.class.cast(paramValue));
                    continue;
                }
                if (paramType == java.util.Date.class) {
                    d = (java.util.Date)java.util.Date.class.cast(paramValue);
                    pstmt.setDate(index, new Date(d.getTime()));
                    continue;
                }
                if (paramType == Date.class) {
                    d = (Date)Date.class.cast(paramValue);
                    pstmt.setDate(index, (Date)d);
                    continue;
                }
                if (paramType == Long.TYPE) {
                    pstmt.setLong(index, (Long)Long.class.cast(paramValue));
                    continue;
                }
                if (paramType == Double.TYPE) {
                    pstmt.setDouble(index, (Double)Double.class.cast(paramValue));
                    continue;
                }
                if (paramType == BigInteger.class) {
                    throw new Exception("unsupported type BigInteger");
                }
                if (paramType == BigDecimal.class) {
                    pstmt.setBigDecimal(index, (BigDecimal)BigDecimal.class.cast(paramValue));
                    continue;
                }
                if (paramType == Boolean.TYPE) {
                    pstmt.setBoolean(index, (Boolean)Boolean.class.cast(paramValue));
                    continue;
                }
                throw new Exception("unsupported type " + paramType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        block59: {
            Pattern p22;
            Matcher m;
            Object obj;
            long remainingTime = System.currentTimeMillis();
            String methodName = method.getName();
            if (methodName.equals("toString")) {
                String result = this.queryBeans.toString();
                return result;
            }
            if (this.commandAcceptor.accept(method)) {
                Class<?> proxyCls = this.ctrlCommandProxy.getClass();
                Method cmdMethod = proxyCls.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return cmdMethod.invoke(this.ctrlCommandProxy, args);
            }
            SQLInterfaceBean inBean = null;
            for (SQLInterfaceBean aBean : this.queryBeans) {
                if (!methodName.equals(aBean.id)) continue;
                inBean = aBean;
                break;
            }
            if (inBean == null) {
                throw new Exception("QueryInterface\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
            }
            String conditionedSQL = BLANK;
            if (args != null && args.length > 1 && (obj = args[1]) instanceof QueryCondition && (m = (p22 = Pattern.compile("#@condition#")).matcher(inBean.sqlStr)).find()) {
                QueryCondition condition = (QueryCondition)obj;
                String conditionStr = condition.renderCondition();
                conditionedSQL = inBean.sqlStr.replace("#@condition#", conditionStr);
            }
            if (conditionedSQL.isEmpty()) {
                conditionedSQL = inBean.sqlStr;
            }
            PreparedStatement pstmt = null;
            if (prepareCache.containsKey(conditionedSQL)) {
                pstmt = prepareCache.get(conditionedSQL);
                if (pstmt.isClosed()) {
                    pstmt = this.con.prepareStatement(conditionedSQL);
                    prepareCache.put(conditionedSQL, (SQLInterfacePreparedStatement)pstmt);
                }
            } else {
                pstmt = this.con.prepareStatement(conditionedSQL);
                ((SQLInterfacePreparedStatement)pstmt).setInterfaceBean(inBean);
                prepareCache.put(conditionedSQL, (SQLInterfacePreparedStatement)pstmt);
            }
            pstmt.clearParameters();
            if ("SELECT".equals(inBean.type)) {
                if (inBean.map != null) {
                    try {
                        if (args != null && args.length != 0 && args[0] != null) {
                            this.initStatement(inBean, pstmt, args[0]);
                        }
                    }
                    catch (Exception p22) {
                        // empty catch block
                    }
                }
                ArrayList result0 = null;
                Class<?> cls = method.getReturnType();
                Class returnType = null;
                if (cls.equals(List.class)) {
                    ParameterizedType paramType = (ParameterizedType)method.getGenericReturnType();
                    Type[] typeArray = paramType.getActualTypeArguments();
                    returnType = (Class)typeArray[0];
                    if (returnType == null) {
                        throw new Exception("query SELECT unknown return type");
                    }
                    ArrayList result = new ArrayList();
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Object obj2 = DaoHelper.convertResult(rs, returnType);
                        result.add(obj2);
                    }
                    try {
                        rs.close();
                        pstmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    result0 = result;
                } else {
                    void var14_28;
                    ResultSet rs = pstmt.executeQuery();
                    Object var14_25 = null;
                    Class cls0 = null;
                    cls0 = cls == Integer.TYPE ? Integer.class : (cls == Long.TYPE ? Long.class : (cls == Double.TYPE ? Double.class : (cls == Boolean.TYPE ? Boolean.class : cls)));
                    if (rs.next()) {
                        Integer n = DaoHelper.convertResult(rs, cls0);
                    } else {
                        List<Object> result = Arrays.asList(cls0.newInstance());
                        result.clear();
                        List<Object> list = result;
                    }
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    result0 = var14_28;
                }
                return result0;
            }
            if ("INSERT".equals(inBean.type) || "UPDATE".equals(inBean.type) || "DELETE".equals(inBean.type)) {
                pstmt.clearParameters();
                Class<?>[] paramTypes = method.getParameterTypes();
                ArrayList<Object> operatedList = new ArrayList<Object>();
                if (paramTypes.length > 0) {
                    Class<?> paramType = paramTypes[0];
                    if (List.class.equals(paramType)) {
                        Object param = args[0];
                        List list = (List)param;
                        for (Object o : list) {
                            if (inBean.map == null) continue;
                            this.initStatement(inBean, pstmt, o);
                            pstmt.addBatch();
                            pstmt.clearParameters();
                            operatedList.add(o);
                        }
                    } else if (paramType.isArray()) {
                        void var14_31;
                        int length = Array.getLength(args[0]);
                        boolean bl = false;
                        while (var14_31 < length) {
                            Object o;
                            o = Array.get(args[0], (int)var14_31);
                            if (inBean.map != null) {
                                this.initStatement(inBean, pstmt, o);
                                pstmt.addBatch();
                                pstmt.clearParameters();
                                operatedList.add(o);
                            }
                            ++var14_31;
                        }
                    } else if (inBean.map != null) {
                        this.initStatement(inBean, pstmt, args[0]);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                        operatedList.add(args[0]);
                    }
                } else {
                    pstmt.addBatch();
                }
                try {
                    Class<?> methodReturnType;
                    if (!this.manualTransaction) {
                        this.con.setAutoCommit(this.useAutoCommit);
                    }
                    int[] results = pstmt.executeBatch();
                    if (!this.manualTransaction) {
                        if (!this.useAutoCommit) {
                            SQLInterfaceEvent event = null;
                            remainingTime = System.currentTimeMillis() - remainingTime;
                            if ("INSERT".equals(inBean.type)) {
                                InsertEvent insertEvent = new InsertEvent();
                                insertEvent.setInsertedObjects(operatedList);
                                insertEvent.setInterfaceBean(inBean);
                                insertEvent.setRemainingTime(remainingTime);
                                event = insertEvent;
                            } else if ("UPDATE".equals(inBean.type)) {
                                UpdateEvent updateEvent = new UpdateEvent();
                                updateEvent.setUpdatedObjects(operatedList);
                                updateEvent.setInterfaceBean(inBean);
                                updateEvent.setRemainingTime(remainingTime);
                                event = updateEvent;
                            } else if ("DELETE".equals(inBean.type)) {
                                DeleteEvent deleteEvent = new DeleteEvent();
                                deleteEvent.setDeletedObjects(operatedList);
                                deleteEvent.setInterfaceBean(inBean);
                                deleteEvent.setRemainingTime(remainingTime);
                                event = deleteEvent;
                            }
                            this.con.commitWith(event);
                        }
                    } else {
                        CommandDataPair pair = new CommandDataPair();
                        pair.setSqlInterfaceBean(inBean);
                        for (Object e : operatedList) {
                            pair.addData(e);
                        }
                        this.con.addCommand(pair);
                    }
                    if ((methodReturnType = method.getReturnType()).getComponentType() != null && methodReturnType.getComponentType().equals(Integer.TYPE)) {
                        return results;
                    }
                    break block59;
                }
                catch (SQLException e) {
                    if (!this.manualTransaction) {
                        if (!this.useAutoCommit) {
                            this.con.rollback();
                            RollBackEvent event = new RollBackEvent();
                            event.setCause(e);
                            event.setInterfaceBean(inBean);
                            SQLInterfaceEventProcessor.newInstance().broadcast(event);
                            Class<?> clazz = method.getReturnType();
                            if (clazz.getComponentType() != null && clazz.getComponentType().equals(Integer.TYPE)) {
                                return new int[0];
                            }
                        }
                        break block59;
                    }
                    throw e;
                }
            }
            if ("CREATE".equals(inBean.type)) {
                pstmt.executeUpdate();
            } else {
                try {
                    if (!this.manualTransaction) {
                        this.con.setAutoCommit(this.useAutoCommit);
                    }
                    pstmt.execute();
                    if (!this.manualTransaction && !this.useAutoCommit) {
                        this.con.commit();
                    }
                }
                catch (SQLException e) {
                    if (!this.manualTransaction) {
                        if (!this.useAutoCommit) {
                            this.con.rollback();
                            RollBackEvent event = new RollBackEvent();
                            event.setCause(e);
                            SQLInterfaceEventProcessor.newInstance().broadcast(event);
                        }
                    }
                    throw e;
                }
            }
        }
        return null;
    }
}

