package org.dyndns.nuda.mapper.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * SQLXMLを参照することを示す注釈です
 * 
 * @author nkoseki
 * 
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface JDBCQuery {
	
	/**
	 * クラスローダ上でのSQLXMLの位置を表します
	 * 
	 * @return クラスローダ上でのSQLXMLの位置
	 */
	public String sqlxml();
}
