package org.dyndns.nuda.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataTable {
	private Map<String, List<Object>>	map			= new ConcurrentHashMap<String, List<Object>>();
	private int							lastIndex	= 0;
	private List<String>				columns;
	private String						name;
	
	public DataTable(final String name, final List<String> columns) {
		for (String column : columns) {
			List<Object> row = Collections
					.synchronizedList(new LinkedList<Object>());
			this.map.put(column, row);
		}
		this.columns = columns;
		this.name = name;
	}
	
	public List<String> getHeader() {
		return this.columns;
	}
	
	public String getName() {
		return this.name;
	}
	
	public Map<String, Object> getRow(final int rowNumber) {
		Map<String, Object> result = new HashMap<String, Object>();
		for (String key : this.map.keySet()) {
			List<Object> obj = this.map.get(key);
			if (obj.size() > rowNumber) {
				Object item = obj.get(rowNumber);
				result.put(key, item);
			} else {
				// エラー
			}
		}
		
		return result;
	}
	
	public List<Map<String, Object>> getRows(final int startIndex,
			final int endIndex) {
		List<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
		for (int i = startIndex; i <= endIndex; i++) {
			Map<String, Object> aRow = new HashMap<String, Object>();
			for (String key : this.map.keySet()) {
				
				List<Object> obj = this.map.get(key);
				if (obj.size() > i) {
					Object item = obj.get(i);
					aRow.put(key, item);
				} else {
					// エラー
				}
			}
			result.add(aRow);
		}
		
		return result;
	}
	
	public List<Map<String, Object>> getRows() {
		List<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
		for (int i = 0; i <= this.lastIndex; i++) {
			Map<String, Object> aRow = new HashMap<String, Object>();
			for (String key : this.map.keySet()) {
				
				List<Object> obj = this.map.get(key);
				if (obj.size() > i) {
					Object item = obj.get(i);
					aRow.put(key, item);
				} else {
					// エラー
					
				}
			}
			result.add(aRow);
		}
		
		return result;
	}
	
	/**
	 * 引数に指定されたDataTableオブジェクトに対してINNER JOIN(内部結合)を実行します
	 * 
	 * @param table
	 * @return INNER JOINされたDataTableオブジェクト
	 */
	public DataTable innerJoin(final DataTable table) {
		List<String> newColumns = Collections
				.synchronizedList(new LinkedList<String>());
		Collections.copy(newColumns, this.getHeader());
		
		List<String> targetColumns = table.getHeader();
		
		newColumns.addAll(targetColumns);
		
		return null;
	}
	
	/**
	 * 引数に指定されたDataTableオブジェクトに対してOUTER JOIN(外部結合)を実行します
	 * 
	 * @param table
	 * @return OUTER JOINされたDataTableオブジェクト
	 */
	public DataTable outerJoin(final DataTable table) {
		return null;
	}
	
	public int size() {
		return this.lastIndex;
	}
}
