/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dyndns.nuda.mapper.DaoHelper;
import org.dyndns.nuda.mapper.QueryCondition;
import org.dyndns.nuda.mapper.QueryXMLBean;
import org.dyndns.nuda.mapper.QueryXMLReader;
import org.dyndns.nuda.mapper.annotation.JDBCQuery;
import org.dyndns.nuda.util.ReflectUtil;
import org.dyndns.nuda.util.StringUtil;
import org.slf4j.LoggerFactory;

public class JDBCXMLInvocationHandler
implements InvocationHandler {
    private List<InnerBean> queryBeans = new ArrayList<InnerBean>();
    private Connection con = null;
    public static final int FLAGS = 40;
    private static final String QST = "?";
    private static final String SPACE = " ";
    private static final String BLANK = "";
    private static final String p1StrSub = "(like|=|>|<|<=|>=)\\s+?(\\S+?\\s*?/\\*.+?\\*/)";
    private static final String p2Str = "(\\S+?\\s*/\\*\\s*?(.+?)\\s*?\\*/)";
    private static final String p1InsStr = "((\\d+|'.*?')\\s*?(/\\*.+?\\*/))";
    private static final Pattern P1INS = Pattern.compile("((\\d+|'.*?')\\s*?(/\\*.+?\\*/))", 40);
    private static final String p2InsStr = "((\\S+?\\s*|'.+')\\s*?/\\*\\s*?(.+?)\\s*?\\*/)";
    private static final Pattern P2INS = Pattern.compile("((\\S+?\\s*|'.+')\\s*?/\\*\\s*?(.+?)\\s*?\\*/)", 40);
    private static final Pattern P1 = Pattern.compile("(like|=|>|<|<=|>=)\\s+?(\\S+?\\s*?/\\*.+?\\*/)");
    private static final Pattern P2 = Pattern.compile("(\\S+?\\s*/\\*\\s*?(.+?)\\s*?\\*/)", 40);
    private static Map<String, PreparedStatement> prepareCache = new HashMap<String, PreparedStatement>();

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass) throws Exception {
        if (handlerClass == null) {
            return;
        }
        if (!handlerClass.isInterface()) {
            String format = "unsupported class {}. class is not a interface";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            throw new Exception(message);
        }
        if (handlerClass.isAnnotationPresent(JDBCQuery.class)) {
            this.con = con;
            JDBCQuery query = handlerClass.getAnnotation(JDBCQuery.class);
            String xmlPath = query.sqlxml();
            QueryXMLReader reader = new QueryXMLReader();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlPath);
            reader.read(is);
            List<QueryXMLBean> result = reader.getResult();
            for (QueryXMLBean xmlBean : result) {
                InnerBean inBean = this.convertSQLFromXML(xmlBean.getType(), xmlBean.getSql());
                inBean.id = xmlBean.getId();
                inBean.type = xmlBean.getType();
                this.queryBeans.add(inBean);
            }
        } else {
            String format = "unsupported class {}. class is not supported annotation<org.dyndns.nuda.repserv.datastore.annotation.JDBCQuery>";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            throw new Exception(message);
        }
    }

    public JDBCXMLInvocationHandler(Connection con, Class<?> handlerClass, ClassLoader loader) throws Exception {
        if (handlerClass == null) {
            return;
        }
        if (!handlerClass.isInterface()) {
            String format = "unsupported class {}. class is not a interface";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            throw new Exception(message);
        }
        if (handlerClass.isAnnotationPresent(JDBCQuery.class)) {
            this.con = con;
            JDBCQuery query = handlerClass.getAnnotation(JDBCQuery.class);
            String xmlPath = query.sqlxml();
            QueryXMLReader reader = new QueryXMLReader();
            InputStream is = loader.getResourceAsStream(xmlPath);
            reader.read(is);
            List<QueryXMLBean> result = reader.getResult();
            is.close();
            for (QueryXMLBean xmlBean : result) {
                InnerBean inBean = this.convertSQLFromXML(xmlBean.getType(), xmlBean.getSql());
                inBean.id = xmlBean.getId();
                inBean.type = xmlBean.getType();
                this.queryBeans.add(inBean);
            }
        } else {
            String format = "unsupported class {}. class is not supported annotation<org.dyndns.nuda.repserv.datastore.annotation.JDBCQuery>";
            String message = StringUtil.format((String)format, (Object[])new Object[]{handlerClass});
            throw new Exception(message);
        }
    }

    private JDBCXMLInvocationHandler() {
    }

    public static void main(String[] args) {
        StringBuilder b = new StringBuilder();
        b.append("\tINSERT INTO sandbox(").append("\n");
        b.append("\t\tsan_id, ").append("\n");
        b.append("\t\tsan_name, ").append("\n");
        b.append("\t\tsan_date").append("\n");
        b.append("\t) values(").append("\n");
        b.append("\t\t1 /* san_id */, ").append("\n");
        b.append("\t\t''/* san_name */, ").append("\n");
        b.append("\t\t'2013-07-04 00:00:00'/*san_date*/").append("\n");
        b.append("\t)").append("\n");
        JDBCXMLInvocationHandler h = new JDBCXMLInvocationHandler();
        InnerBean bean = h.convertSQLFromXML("UPDATE", b.toString());
        System.out.println(bean);
        b = new StringBuilder();
        b.append("\tUPDATE sandbox SET").append("\n");
        b.append("\t\tsan_name = ''").append("\n");
        b.append("\tWHERE").append("\n");
        b.append("\t\tsan_id = 1/* san_id */").append("\n");
        bean = h.convertSQLFromXML("INSERT", b.toString());
        System.out.println(bean);
        b = new StringBuilder();
        b.append("\tDELETE FROM sandbox").append("\n");
        b.append("\tWHERE").append("\n");
        b.append("\t\tsan_id = 1/* san_id */").append("\n");
        bean = h.convertSQLFromXML("DELETE", b.toString());
        System.out.println(bean);
        b = new StringBuilder();
        b.append("\tINSERT INTO dai_data(").append("\n");
        b.append("\t\tseq, ").append("\n");
        b.append("\t\tan_date, ").append("\n");
        b.append("\t\tbig, ").append("\n");
        b.append("\t\treg, ").append("\n");
        b.append("\t\tgame, ").append("\n");
        b.append("\t\tprov, ").append("\n");
        b.append("\t\timagepath, ").append("\n");
        b.append("\t\tgraph_image_url").append("\n");
        b.append("\t) VALUES(").append("\n");
        b.append("\t\t1/* seq */, ").append("\n");
        b.append("\t\t'2013-07-04'/* an_date */, ").append("\n");
        b.append("\t\t1/* big */, ").append("\n");
        b.append("\t\t1/* reg */, ").append("\n");
        b.append("\t\t1/* game */, ").append("\n");
        b.append("\t\t1.0/* prov */, ").append("\n");
        b.append("\t\t''/* imagepath */, ").append("\n");
        b.append("\t\t''/* graph_image_url */").append("\n");
        b.append("\t)").append("\n");
        bean = h.convertSQLFromXML("INSERT", b.toString());
        System.out.println(bean);
    }

    private InnerBean convertSQLFromXML(String queryType, String queryStr) {
        InnerBean bean = new InnerBean();
        if ("SELECT".equals(queryType)) {
            String source = queryStr;
            Matcher m = P1.matcher(source);
            String result0 = BLANK;
            HashMap<Integer, String> matchMap = new HashMap<Integer, String>();
            int matchIndex = 0;
            while (m.find()) {
                int startRegion = m.regionStart();
                int endRegion = m.regionEnd();
                Matcher subMatcher = m.region(startRegion, endRegion);
                subMatcher.usePattern(P2);
                while (subMatcher.find()) {
                    String result2;
                    String matchResult = subMatcher.group(2);
                    matchMap.put(matchIndex + 1, matchResult.replace(SPACE, BLANK));
                    result0 = result2 = subMatcher.replaceFirst(QST);
                    subMatcher.reset(result2);
                    ++matchIndex;
                }
            }
            if (result0.isEmpty()) {
                result0 = queryStr;
            }
            bean.sqlStr = result0;
            bean.map = matchMap;
        } else if ("INSERT".equals(queryType) || "UPDATE".equals(queryType) || "DELETE".equals(queryType)) {
            String source = queryStr;
            Matcher m = P1INS.matcher(source);
            String result0 = BLANK;
            HashMap<Integer, String> matchMap = new HashMap<Integer, String>();
            int matchIndex = 0;
            while (m.find()) {
                int startRegion = m.regionStart();
                int endRegion = m.regionEnd();
                Matcher subMatcher = m.region(startRegion, endRegion);
                subMatcher.usePattern(P2INS);
                while (subMatcher.find()) {
                    String result2;
                    String matchResult = subMatcher.group(3);
                    matchMap.put(matchIndex + 1, matchResult.replace(SPACE, BLANK));
                    result0 = result2 = subMatcher.replaceFirst(QST);
                    subMatcher.reset(result2);
                    ++matchIndex;
                }
            }
            if (result0.isEmpty()) {
                result0 = queryStr;
            }
            bean.sqlStr = result0;
            bean.map = matchMap;
        } else {
            bean.sqlStr = queryStr;
            bean.map = null;
        }
        return bean;
    }

    private void initStatement(InnerBean inBean, PreparedStatement pstmt, Object parameter) throws Exception {
        block14: {
            if (inBean.map == null) break block14;
            for (Map.Entry entry : inBean.map.entrySet()) {
                java.util.Date d;
                int index = (Integer)entry.getKey();
                String propName = (String)entry.getValue();
                if (parameter == null) continue;
                Object param01 = parameter;
                String realMethodName = ReflectUtil.PREFIX.GETTER.camelCaseTo(propName);
                Method getterMethod = null;
                try {
                    getterMethod = param01.getClass().getDeclaredMethod(realMethodName, new Class[0]);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger((String)"JDBCHandler#initStatement").error("\u30e1\u30bd\u30c3\u304c\u3042\u308a\u307e\u305b\u3093", (Throwable)e);
                    throw e;
                }
                Class<?> paramType = getterMethod.getReturnType();
                Object paramValue = getterMethod.invoke(param01, new Object[0]);
                if (paramType == Integer.TYPE) {
                    pstmt.setInt(index, (Integer)Integer.class.cast(paramValue));
                    continue;
                }
                if (paramType == String.class) {
                    pstmt.setString(index, (String)String.class.cast(paramValue));
                    continue;
                }
                if (paramType == java.util.Date.class) {
                    d = (java.util.Date)java.util.Date.class.cast(paramValue);
                    pstmt.setDate(index, new Date(d.getTime()));
                    continue;
                }
                if (paramType == Date.class) {
                    d = (Date)Date.class.cast(paramValue);
                    pstmt.setDate(index, (Date)d);
                    continue;
                }
                if (paramType == Long.TYPE) {
                    pstmt.setLong(index, (Long)Long.class.cast(paramValue));
                    continue;
                }
                if (paramType == Double.TYPE) {
                    pstmt.setDouble(index, (Double)Double.class.cast(paramValue));
                    continue;
                }
                if (paramType == BigInteger.class) {
                    throw new Exception("unsupported type BigInteger");
                }
                if (paramType == BigDecimal.class) {
                    pstmt.setBigDecimal(index, (BigDecimal)BigDecimal.class.cast(paramValue));
                    continue;
                }
                if (paramType == Boolean.TYPE) {
                    pstmt.setBoolean(index, (Boolean)Boolean.class.cast(paramValue));
                    continue;
                }
                throw new Exception("unsupported type " + paramType);
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Pattern p;
        Matcher m;
        Object obj;
        String methodName = method.getName();
        if (methodName.equals("toString")) {
            String result = this.queryBeans.toString();
            return result;
        }
        LoggerFactory.getLogger((String)"JDBCXMLInvocationHandler").debug("\u30af\u30a8\u30ea\u306e\u5b9f\u884c\u3092\u958b\u59cb\u3057\u307e\u3059: {}", (Object)methodName);
        InnerBean inBean = null;
        for (InnerBean aBean : this.queryBeans) {
            if (!methodName.equals(aBean.id)) continue;
            inBean = aBean;
            break;
        }
        if (inBean == null) {
            throw new Exception("QueryInterface\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        String conditionedSQL = BLANK;
        if (args != null && args.length > 1 && (obj = args[1]) instanceof QueryCondition && (m = (p = Pattern.compile("#@condition#")).matcher(inBean.sqlStr)).find()) {
            QueryCondition condition = (QueryCondition)obj;
            String conditionStr = condition.renderCondition();
            conditionedSQL = inBean.sqlStr.replace("#@condition#", conditionStr);
            LoggerFactory.getLogger((String)"JDBCXMLInvocationHandler").debug("SQL\u30b3\u30f3\u30c7\u30a3\u30b7\u30e7\u30f3\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\n{}", (Object)conditionedSQL);
        }
        if (conditionedSQL.isEmpty()) {
            conditionedSQL = inBean.sqlStr;
        }
        PreparedStatement pstmt = null;
        if (prepareCache.containsKey(conditionedSQL)) {
            pstmt = prepareCache.get(conditionedSQL);
            if (pstmt.isClosed()) {
                pstmt = this.con.prepareStatement(conditionedSQL);
                prepareCache.put(conditionedSQL, pstmt);
            }
        } else {
            pstmt = this.con.prepareStatement(conditionedSQL);
            prepareCache.put(conditionedSQL, pstmt);
        }
        pstmt.clearParameters();
        LoggerFactory.getLogger((String)"JDBCXMLInvocationHandler").debug("\u30af\u30a8\u30ea\u5b9f\u884c\n{}", (Object)inBean.sqlStr);
        if ("SELECT".equals(inBean.type)) {
            if (inBean.map != null) {
                try {
                    if (args != null && args.length != 0 && args[0] != null) {
                        this.initStatement(inBean, pstmt, args[0]);
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger((String)"JDBCXMLInvocationHandler").error("error", (Throwable)e);
                }
            }
            Serializable result0 = null;
            Class<?> cls = method.getReturnType();
            Class returnType = null;
            if (cls.equals(List.class)) {
                ParameterizedType paramType = (ParameterizedType)method.getGenericReturnType();
                Type[] types = paramType.getActualTypeArguments();
                returnType = (Class)types[0];
                if (returnType == null) {
                    throw new Exception("query SELECT unknown return type");
                }
                ArrayList result = new ArrayList();
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    Object obj2 = DaoHelper.convertResult(rs, returnType);
                    result.add(obj2);
                }
                try {
                    rs.close();
                    pstmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result0 = result;
            } else {
                ResultSet rs = pstmt.executeQuery();
                Integer obj3 = null;
                Class cls0 = null;
                Integer errorResult = null;
                if (cls == Integer.TYPE) {
                    cls0 = Integer.class;
                    errorResult = 0;
                } else if (cls == Long.TYPE) {
                    cls0 = Long.class;
                    errorResult = 0;
                } else {
                    cls0 = cls == Double.TYPE ? Double.class : (cls == Boolean.TYPE ? Boolean.class : cls);
                }
                if (!rs.next()) {
                    throw new Exception("ResultSet\u306b\u3088\u3063\u30660\u884c\u304c\u8fd4\u5374\u3055\u308c\u305f\u305f\u3081\u3001\u5024\u306e\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f(\u5024\u8a2d\u5b9a\u5bfe\u8c61\u30af\u30e9\u30b9:" + cls.getCanonicalName() + ")");
                }
                obj3 = DaoHelper.convertResult(rs, cls0);
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result0 = obj3;
            }
            return result0;
        }
        if ("INSERT".equals(inBean.type) || "UPDATE".equals(inBean.type) || "DELETE".equals(inBean.type)) {
            pstmt.clearParameters();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length > 0) {
                Class<?> paramType = paramTypes[0];
                if (List.class.equals(paramType)) {
                    Object param = args[0];
                    List paramList = (List)param;
                    for (Object o : paramList) {
                        if (inBean.map == null) continue;
                        this.initStatement(inBean, pstmt, o);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                } else if (paramType.isArray()) {
                    int length = Array.getLength(args[0]);
                    int i = 0;
                    while (i < length) {
                        Object o = Array.get(args[0], i);
                        if (inBean.map != null) {
                            this.initStatement(inBean, pstmt, o);
                            pstmt.addBatch();
                            pstmt.clearParameters();
                        }
                        ++i;
                    }
                } else if (inBean.map != null) {
                    this.initStatement(inBean, pstmt, args[0]);
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
            }
            this.con.setAutoCommit(false);
            try {
                try {
                    pstmt.executeBatch();
                    this.con.commit();
                }
                catch (SQLException e) {
                    LoggerFactory.getLogger((String)"JDBCXMLInvocationHandler").error("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3078\u306e\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
                    this.con.rollback();
                    pstmt.close();
                }
            }
            finally {
                pstmt.close();
            }
        } else {
            this.con.setAutoCommit(false);
            try {
                pstmt.execute();
                this.con.commit();
            }
            catch (SQLException e) {
                LoggerFactory.getLogger((String)"JDBCXMLInvocationHandler").error("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3078\u306e\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
                this.con.rollback();
            }
        }
        return null;
    }

    class InnerBean {
        private String id = "";
        private String type = "";
        private String sqlStr = "";
        private Map<Integer, String> map = null;

        InnerBean() {
        }

        public String toString() {
            return "InnerBean [id=" + this.id + ", type=" + this.type + ", sqlStr=" + this.sqlStr + ", map=" + this.map + "]";
        }
    }
}

