#include "global.h"
#include "struct.h"

#include <string.h>

// S or D
char copy_mode;

// 関数プロトタイプ
void same_or_different(UNList *hdd_list, struct argument *arg_from, struct argument *arg_to);

/*******************************************************************************
同一HDDかどうか確認し、copy_modeを設定
*******************************************************************************/
void same_or_different(UNList *hdd_list, struct argument *arg_from, struct argument *arg_to)
{
	UNList *tmp_list = hdd_list;
	arg_from->hdd_dev = NULL;
	arg_to->hdd_dev = NULL;

	for(;;)
	{
		struct hdd_path *tmp = (struct hdd_path *)tmp_list->data;

		if((strncmp(tmp->hdd_mount, arg_from->path, strlen(tmp->hdd_mount))) == 0)
		{
			arg_from->hdd_dev = tmp->hdd_dev;
		}
		if((strncmp(tmp->hdd_mount, arg_to->path, strlen(tmp->hdd_mount))) == 0)
		{
			arg_to->hdd_dev = tmp->hdd_dev;
		}

		if(tmp_list->next != NULL)
		{
			tmp_list = tmp_list->next;
		}
		else { break; }
	}

	if((arg_from->hdd_dev != NULL) && (arg_to->hdd_dev != NULL))
	{
		if((strcmp(arg_from->hdd_dev, arg_to->hdd_dev)) == 0)
		{
			copy_mode = SAME;
		}
		else if((strcmp(arg_from->hdd_dev, arg_to->hdd_dev)) != 0)
		{
			copy_mode = DIFFERENT;
		}
	}
	else
	{
		copy_mode = SAME;
	}
}
