#include "struct.h"

#include <stdlib.h>

// 関数プロトタイプ
UNList * list_append(UNList *vlist, void *tmp);

/*******************************************************************************
連結リストに構造体を追加し、リストを繋ぐ
*******************************************************************************/
UNList * list_append(UNList *vlist, void *tmp)
{
	UNList *first = vlist;

	if(first != NULL)
	{
		UNList *now = malloc(sizeof(UNList));
		now->data = (void *)tmp;
		now->next = NULL;
		now->tail = NULL;

		UNList *before_last;
		before_last = first->tail;
		before_last->next = now;
		first->tail = now;
	}
	// リストに最初の要素を追加する
	else
	{
		first = malloc(sizeof(UNList));
		first->data = (void *)tmp;
		first->next = NULL;
		first->tail = first;
	}

	/*
	なぜ返すのがvlistでは駄目かというと、
	最初にデータをリストに追加する時点ではvlistはNULLだから。
	vlistを返すとSegmentation faultで落ちる。
	*/
	return first;
}
