package smart_gs.util;

import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Spread;

/**
 * 画像中の座標と翻刻テキスト中の位置の対応を推定するためのインターフェイス
 * @author yuta
 *
 */
public interface TextLocationEstimator {
	
	/**
	 * 画像中の座標から、指定行中の文字のインデックスを推定する
	 * @param line
	 * @param x
	 * @param y
	 * @return 行中のインデックス
	 */
	int guessCharIndex(LineSegment line, int x, int y);
	
	/**
	 * 行番号と行テキスト、行中の文字インデックスから、画像中の位置座標を推定する
	 * @param spread
	 * @param lineNum
	 * @param charIndex
	 * @return 推定した画像中のx,y座標の配列
	 */
	int[] guessTextPosition(Spread spread, int lineNum, String lineText, int charIndex);

}
