package smart_gs.util;

import java.awt.Rectangle;

import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Spread;

public class SimpleTextLocationEstimator implements TextLocationEstimator {
	
	
	private int textType = TextType.HORIZONTAL;
	private int pxPerChar = 20; // 1文字毎のピクセル数（デフォルト20）
	
	public SimpleTextLocationEstimator(int pxPerChar, int textType) {
		this.textType = textType;
		this.pxPerChar = pxPerChar;		
	}
	
	public SimpleTextLocationEstimator() {		
	}

	@Override
	public int guessCharIndex(LineSegment line, int x, int y) {		
		int charIndex = 0;
		if (this.textType == TextType.VERTICAL) {
			line.getView().getRectangle().getY();
			int lineY = (int) line.getView().getRectangle().getY();
			int diff = y - lineY;
			if (diff < 0) diff = 0;
			charIndex = diff / this.pxPerChar;
		} else {
			int lineX = (int) line.getView().getRectangle().getX();
			int diff = x - lineX;
			if (diff < 0) diff = 0;
			charIndex = diff / this.pxPerChar;
		}
		return charIndex;
	}

	@Override
	public int[] guessTextPosition(Spread spread, int lineNum, 
			String lineText, int charIndex) {		
		LineSegment line = spread.getLines().get(lineNum);		
		Rectangle rect = line.getView().getRectangle();
		double ratio = charIndex/lineText.length();		
		if (this.textType == TextType.HORIZONTAL) {			
			int x = (int) (rect.getX() + ratio*rect.getWidth());
			int y = (int) (rect.getY() + rect.getHeight()/2);
			int[] coordinate = {x,y};
			return coordinate;
		} else {
			int x = (int) (rect.getX() + rect.getWidth()/2);
			int y = (int) (rect.getY() + ratio*rect.getHeight());
			int[] coordinate = {x,y};
			return coordinate;
		}
	}

}
