package smart_gs.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageProperties {
	
	private static MessageProperties singleton = new MessageProperties();
	private ResourceBundle bundle;

	public MessageProperties() {
		// load locale setting
		try {
			Locale locale = Locale.getDefault();
			this.bundle = ResourceBundle.getBundle("messages", locale);
		} catch (MissingResourceException e) {
			this.bundle = ResourceBundle.getBundle("messages", Locale.US);
		}
	}
	
	public static MessageProperties getInstance() {
		return singleton;
	}
	
	public String getMsg(String key) {
		return this.bundle.getString(key);
	}

}
