/* $Id: SearchTextAction.java 609 2012-11-29 10:22:01Z ohura $ */
package smart_gs.text_search;

import smart_gs.text_search.SearchAction;
import smart_gs.logical.Spread;
import java.util.ArrayList;

public class SearchTextAction extends SearchAction {
	private String queryText;
	private int documentType;
	private boolean isCaseSensitive;
	private boolean isRegularExpressions;
	private ArrayList<Spread> spreadsToSearch;
	
	public SearchTextAction(String queryText, ArrayList<Spread> spreadsToSearch, int documentType,boolean isCaseSensitive,boolean isRegularExpressions){
		super(spreadsToSearch);
		this.spreadsToSearch = spreadsToSearch;
		this.queryText = queryText;
		this.documentType = documentType;
		this.isCaseSensitive = isCaseSensitive;
		this.isRegularExpressions = isRegularExpressions;
	}
	public void execute(){
		TextSearchEngine searchEngine = TextSearchEngine.getInstance();
		searchEngine.setQueryText(queryText);
		searchEngine.setCaseSensitive(isCaseSensitive);
		searchEngine.setRegularExpressions(isRegularExpressions);
		searchEngine.setSearchScope(spreadsToSearch);
		searchEngine.setDocumentType(documentType);
		searchEngine.execute();
		this.results = searchEngine.getResults();
	}
	public ArrayList<Spread> getSpreadsToSearch() {
		return spreadsToSearch;
	}	
	public int getDocumentType() {
		return documentType;
	}
	public boolean getIsCaseSensitive() {
		return isCaseSensitive;
	}
	public boolean getIsRegularExpressions() {
		return isRegularExpressions;
	}


}
